/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.sun;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinker;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.sun.C89Processor;
import net.sf.antcontrib.cpptasks.types.LibrarySet;

public final class C89Linker
extends CommandLineLinker {
    private static final C89Linker instance = new C89Linker("", "");
    private static final C89Linker dllLinker = new C89Linker("lib", ".so");
    private String outputPrefix;

    private C89Linker(String outputPrefix, String outputSuffix) {
        super("ld", "/bogus", new String[]{".o", ".a", ".lib", ".x"}, new String[0], outputSuffix, false, null);
        this.outputPrefix = outputPrefix;
    }

    public static C89Linker getInstance() {
        return instance;
    }

    public File[] getLibraryPath() {
        return CUtil.getPathFromEnvironment("LIB", ";");
    }

    public String getOutputFileName(String baseName) {
        return this.outputPrefix + super.getOutputFileName(baseName);
    }

    protected void addFixed(Boolean fixed, Vector args) {
    }

    protected void addMap(boolean map, Vector args) {
    }

    protected void addBase(long base, Vector args) {
    }

    protected void addIncremental(boolean incremental, Vector args) {
    }

    protected void addStack(int stack, Vector args) {
    }

    public Linker getLinker(LinkType linkType) {
        if (linkType.isSharedLibrary()) {
            return dllLinker;
        }
        return instance;
    }

    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
        if (linkType.isSharedLibrary()) {
            args.addElement("-G");
        }
    }

    public String getCommandFileSwitch(String commandFile) {
        return "@" + commandFile;
    }

    public String[] getOutputFileSwitch(String outputFile) {
        return new String[]{"-o", outputFile};
    }

    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }

    public String[] getLibraryPatterns(String[] libnames) {
        return C89Processor.getLibraryPatterns(libnames);
    }

    public boolean isCaseSensitive() {
        return C89Processor.isCaseSensitive();
    }

    public String[] addLibrarySets(CCTask task, LibrarySet[] libsets, Vector preargs, Vector midargs, Vector endargs) {
        super.addLibrarySets(task, libsets, preargs, midargs, endargs);
        StringBuffer buf = new StringBuffer("-l");
        int i = 0;
        while (i < libsets.length) {
            LibrarySet set = libsets[i];
            File libdir = set.getDir(null);
            String[] libs = set.getLibs();
            if (libdir != null) {
                endargs.addElement("-L");
                endargs.addElement(libdir.getAbsolutePath());
            }
            int j = 0;
            while (j < libs.length) {
                buf.setLength(2);
                buf.append(libs[j]);
                endargs.addElement(buf.toString());
                ++j;
            }
            ++i;
        }
        return null;
    }
}

