/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.os390;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinker;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinkerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.os390.OS390Processor;
import net.sf.antcontrib.cpptasks.types.LibrarySet;
import org.apache.tools.ant.BuildException;

public final class OS390Linker
extends CommandLineLinker {
    private static final OS390Linker instance = new OS390Linker("", "");
    private static final OS390Linker dllLinker = new OS390Linker("", ".dll");
    private static final OS390Linker datasetLinker = new OS390Linker();
    private String outputPrefix;
    private boolean isADatasetLinker;
    File outputFile;
    CCTask task;

    private OS390Linker(String outputPrefix, String outputSuffix) {
        super("cxx", "/bogus", new String[]{".o", ".a", ".lib", ".x"}, new String[]{".dll"}, outputSuffix, false, null);
        this.outputPrefix = outputPrefix;
        this.isADatasetLinker = false;
    }

    private OS390Linker() {
        super("cxx", "/bogus", new String[]{".o", ".a", ".lib", ".xds"}, new String[]{".dll", ".x"}, ".xds", false, null);
        this.outputPrefix = "";
        this.isADatasetLinker = true;
    }

    public static OS390Linker getInstance() {
        return instance;
    }

    public static OS390Linker getDataSetInstance() {
        return datasetLinker;
    }

    public File[] getLibraryPath() {
        return CUtil.getPathFromEnvironment("LIB", ";");
    }

    public String getOutputFileName(String baseName) {
        return this.outputPrefix + super.getOutputFileName(baseName);
    }

    protected void addFixed(Boolean fixed, Vector args) {
    }

    protected void addMap(boolean map, Vector args) {
    }

    protected void addBase(long base, Vector args) {
    }

    protected void addIncremental(boolean incremental, Vector args) {
    }

    protected void addStack(int stack, Vector args) {
    }

    public Linker getLinker(LinkType linkType) {
        if (this == datasetLinker) {
            return datasetLinker;
        }
        if (linkType.isSharedLibrary()) {
            return dllLinker;
        }
        return instance;
    }

    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
        if (linkType.isSharedLibrary()) {
            args.addElement("-W");
            args.addElement("l,DLL");
        }
    }

    public String getCommandFileSwitch(String commandFile) {
        return "@" + commandFile;
    }

    protected String[] getOutputFileSwitch(CCTask task, String outputFile) {
        if (this.isADatasetLinker && task.getDataset() != null) {
            String ds = task.getDataset();
            outputFile = "//'" + ds + "(" + outputFile + ")'";
        }
        return this.getOutputFileSwitch(outputFile);
    }

    public String[] getOutputFileSwitch(String outputFile) {
        return new String[]{"-o", outputFile};
    }

    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }

    public String[] getLibraryPatterns(String[] libnames) {
        return OS390Processor.getLibraryPatterns(libnames);
    }

    public boolean isCaseSensitive() {
        return OS390Processor.isCaseSensitive();
    }

    protected String[] addLibrarySets(CCTask task, LibrarySet[] libsets, Vector preargs, Vector midargs, Vector endargs) {
        if (libsets != null) {
            int i = 0;
            while (i < libsets.length) {
                String[] libs = libsets[i].getLibs();
                int j = 0;
                while (j < libs.length) {
                    if (libs[j].startsWith("//")) {
                        endargs.addElement("-l");
                        endargs.addElement(libs[j]);
                    } else if (libsets[i].getDataset() != null) {
                        String ds = libsets[i].getDataset();
                        endargs.addElement("//'" + ds + "(" + libs[j] + ")'");
                    }
                    ++j;
                }
                ++i;
            }
        }
        return super.addLibrarySets(task, libsets, preargs, midargs, endargs);
    }

    public void link(CCTask task, File outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) throws BuildException {
        int p;
        this.task = task;
        this.outputFile = outputFile;
        if (this.isADatasetLinker && (p = outputFile.getName().indexOf(".")) >= 0) {
            String newname = outputFile.getName().substring(0, p);
            outputFile = new File(outputFile.getParent(), newname);
        }
        super.link(task, outputFile, sourceFiles, config);
    }

    protected int runCommand(CCTask task, File workingDir, String[] cmdline) throws BuildException {
        int rc = super.runCommand(task, workingDir, cmdline);
        if (rc == 0) {
            try {
                this.outputFile.delete();
                new FileOutputStream(this.outputFile).close();
            }
            catch (IOException e) {
                throw new BuildException(e.getMessage());
            }
        }
        return rc;
    }
}

