/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.gcc;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.compiler.Processor;
import net.sf.antcontrib.cpptasks.gcc.GccCompatibleCCompiler;
import net.sf.antcontrib.cpptasks.gcc.GccLinker;
import net.sf.antcontrib.cpptasks.gcc.GccProcessor;
import net.sf.antcontrib.cpptasks.parser.CParser;
import net.sf.antcontrib.cpptasks.parser.FortranParser;
import net.sf.antcontrib.cpptasks.parser.Parser;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;

public final class GccCCompiler
extends GccCompatibleCCompiler {
    private String identifier;
    private File[] includePath;
    private boolean isPICMeaningful = System.getProperty("os.name").indexOf("Windows") < 0;
    private static final String[] sourceExtensions = new String[]{".c", ".cc", ".cpp", ".cxx", ".c++", ".i", ".ii", ".f", ".for", ".m", ".mm", ".s"};
    private static final String[] headerExtensions = new String[]{".h", ".hpp", ".inl"};
    private static final GccCCompiler instance = new GccCCompiler("gcc", sourceExtensions, headerExtensions, false, new GccCCompiler("gcc", sourceExtensions, headerExtensions, true, null, false, null), false, null);
    private static final GccCCompiler cppInstance = new GccCCompiler("c++", sourceExtensions, headerExtensions, false, new GccCCompiler("c++", sourceExtensions, headerExtensions, true, null, false, null), false, null);
    private static final GccCCompiler gppInstance = new GccCCompiler("g++", sourceExtensions, headerExtensions, false, new GccCCompiler("g++", sourceExtensions, headerExtensions, true, null, false, null), false, null);
    private static final GccCCompiler g77Instance = new GccCCompiler("g77", sourceExtensions, headerExtensions, false, new GccCCompiler("g77", sourceExtensions, headerExtensions, true, null, false, null), false, null);

    private GccCCompiler(String command, String[] sourceExtensions, String[] headerExtensions, boolean isLibtool, GccCCompiler libtoolCompiler, boolean newEnvironment, Environment env) {
        super(command, null, sourceExtensions, headerExtensions, isLibtool, libtoolCompiler, newEnvironment, env);
    }

    public static GccCCompiler getInstance() {
        return instance;
    }

    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }

    public static GccCCompiler getCppInstance() {
        return cppInstance;
    }

    public static GccCCompiler getGppInstance() {
        return gppInstance;
    }

    public static GccCCompiler getG77Instance() {
        return g77Instance;
    }

    public void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType) {
        super.addImpliedArgs(args, debug, multithreaded, exceptions, linkType);
        if (this.isPICMeaningful && linkType.isSharedLibrary()) {
            args.addElement("-fPIC");
        }
    }

    public File[] getEnvironmentIncludePath() {
        if (this.includePath == null) {
            String[] defaultInclude = new String[1];
            StringBuffer buf = new StringBuffer("/lib/");
            buf.append(GccProcessor.getMachine());
            buf.append('/');
            buf.append(GccProcessor.getVersion());
            buf.append("/include");
            defaultInclude[0] = buf.toString();
            String[] specs = GccProcessor.getSpecs();
            String[][] optionValues = GccProcessor.parseSpecs(specs, "*cpp:", new String[]{"-isystem ", "-idirafter "});
            if (optionValues[0].length == 0 && optionValues[1].length == 0) {
                optionValues[0] = new String[]{"/usr/local/include", "/usr/include", "/usr/include/win32api"};
            }
            int i = 0;
            while (i < optionValues.length) {
                int j = 0;
                while (j < optionValues[i].length) {
                    if (optionValues[i][j].indexOf("mingw") > 0) {
                        optionValues[i][j] = null;
                    }
                    ++j;
                }
                ++i;
            }
            if (GccProcessor.isCygwin()) {
                GccProcessor.convertCygwinFilenames(optionValues[0]);
                GccProcessor.convertCygwinFilenames(optionValues[1]);
                GccProcessor.convertCygwinFilenames(defaultInclude);
            }
            int count = CUtil.checkDirectoryArray(optionValues[0]);
            count += CUtil.checkDirectoryArray(optionValues[1]);
            this.includePath = new File[count += CUtil.checkDirectoryArray(defaultInclude)];
            int index = 0;
            int i2 = 0;
            while (i2 < optionValues.length) {
                int j = 0;
                while (j < optionValues[i2].length) {
                    if (optionValues[i2][j] != null) {
                        this.includePath[index++] = new File(optionValues[i2][j]);
                    }
                    ++j;
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < defaultInclude.length) {
                if (defaultInclude[i3] != null) {
                    this.includePath[index++] = new File(defaultInclude[i3]);
                }
                ++i3;
            }
        }
        return (File[])this.includePath.clone();
    }

    public String getIdentifier() throws BuildException {
        if (this.identifier == null) {
            StringBuffer buf = this.getLibtool() ? new StringBuffer("libtool ") : new StringBuffer(32);
            buf.append(this.getCommand());
            buf.append(' ');
            buf.append(GccProcessor.getVersion());
            buf.append(' ');
            buf.append(GccProcessor.getMachine());
            this.identifier = buf.toString();
        }
        return this.identifier;
    }

    public Linker getLinker(LinkType linkType) {
        return GccLinker.getInstance().getLinker(linkType);
    }

    protected Parser createParser(File source) {
        char afterDot;
        String sourceName;
        int lastDot;
        if (source != null && (lastDot = (sourceName = source.getName()).lastIndexOf(46)) >= 0 && lastDot + 1 < sourceName.length() && ((afterDot = sourceName.charAt(lastDot + 1)) == 'f' || afterDot == 'F')) {
            return new FortranParser();
        }
        return new CParser();
    }

    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        if (newEnvironment || env != null) {
            return new GccCCompiler(this.getCommand(), this.getSourceExtensions(), this.getHeaderExtensions(), this.getLibtool(), (GccCCompiler)this.getLibtoolCompiler(), newEnvironment, env);
        }
        return this;
    }
}

