/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.compiler;

import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.TargetInfo;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinker;
import net.sf.antcontrib.cpptasks.compiler.LinkerConfiguration;
import org.apache.tools.ant.BuildException;

public final class CommandLineLinkerConfiguration
implements LinkerConfiguration {
    private CommandLineLinker linker;
    private String[][] args;
    private String identifier;
    private boolean rebuild;
    private boolean map;
    private String[] libraryNames;
    private String startupObject;

    public CommandLineLinkerConfiguration(CommandLineLinker linker, String identifier, String[][] args, boolean rebuild, boolean map, String[] libraryNames, String startupObject) {
        if (linker == null) {
            throw new NullPointerException("linker");
        }
        if (args == null) {
            throw new NullPointerException("args");
        }
        this.args = (String[][])args.clone();
        this.linker = linker;
        this.rebuild = rebuild;
        this.identifier = identifier;
        this.map = map;
        this.libraryNames = libraryNames == null ? new String[0] : (String[])libraryNames.clone();
        this.startupObject = startupObject;
    }

    public String toString() {
        return this.identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String[] getPreArguments() {
        String[] clone = (String[])this.args[0].clone();
        return clone;
    }

    public String[] getEndArguments() {
        String[] clone = (String[])this.args[1].clone();
        return clone;
    }

    public boolean getMap() {
        return this.map;
    }

    public void link(CCTask task, TargetInfo linkTarget) throws BuildException {
        String[] sourcePaths = linkTarget.getAllSourcePaths();
        this.linker.link(task, linkTarget.getOutput(), sourcePaths, this);
    }

    public boolean getRebuild() {
        return this.rebuild;
    }

    public int bid(String filename) {
        return this.linker.bid(filename);
    }

    public String getOutputFileName(String inputFile) {
        return this.linker.getOutputFileName(inputFile);
    }

    public String[] getLibraryNames() {
        String[] clone = (String[])this.libraryNames.clone();
        return clone;
    }

    public String getStartupObject() {
        return this.startupObject;
    }
}

