/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.compiler;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.CompilerDef;
import net.sf.antcontrib.cpptasks.ProcessorDef;
import net.sf.antcontrib.cpptasks.compiler.AbstractCompiler;
import net.sf.antcontrib.cpptasks.compiler.AbstractProcessor;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCompilerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.CompilerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.ProgressMonitor;
import net.sf.antcontrib.cpptasks.types.CommandLineArgument;
import net.sf.antcontrib.cpptasks.types.UndefineArgument;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;

public abstract class CommandLineCompiler
extends AbstractCompiler {
    private String command;
    private boolean libtool;
    private CommandLineCompiler libtoolCompiler;
    private String identifier;
    private String identifierArg;
    private final boolean newEnvironment;
    private final Environment env;

    protected CommandLineCompiler(String command, String identifierArg, String[] sourceExtensions, String[] headerExtensions, String outputSuffix, boolean libtool, CommandLineCompiler libtoolCompiler, boolean newEnvironment, Environment env) {
        super(sourceExtensions, headerExtensions, outputSuffix);
        this.command = command;
        if (libtool && libtoolCompiler != null) {
            throw new IllegalArgumentException("libtoolCompiler should be null when libtool is true");
        }
        this.libtool = libtool;
        this.libtoolCompiler = libtoolCompiler;
        this.identifierArg = identifierArg;
        this.newEnvironment = newEnvironment;
        this.env = env;
    }

    protected final String getCommand() {
        return this.command;
    }

    protected abstract String getIncludeDirSwitch(String var1);

    protected abstract void addImpliedArgs(Vector var1, boolean var2, boolean var3, boolean var4, LinkType var5);

    protected abstract void addWarningSwitch(Vector var1, int var2);

    protected abstract void getDefineSwitch(StringBuffer var1, String var2, String var3);

    protected abstract void getUndefineSwitch(StringBuffer var1, String var2);

    public final CommandLineCompiler getLibtoolCompiler() {
        if (this.libtoolCompiler != null) {
            return this.libtoolCompiler;
        }
        return this;
    }

    protected int getMaximumInputFilesPerCommand() {
        return Integer.MAX_VALUE;
    }

    protected int getArgumentCountPerInputFile() {
        return 1;
    }

    protected final boolean getLibtool() {
        return this.libtool;
    }

    protected int getTotalArgumentLengthForInputFile(File outputDir, String inputFile) {
        return inputFile.length() + 1;
    }

    protected String getInputFileArgument(File outputDir, String filename, int index) {
        if (filename.indexOf(32) >= 0) {
            StringBuffer buf = new StringBuffer("\"");
            buf.append(filename);
            buf.append("\"");
            return buf.toString();
        }
        return filename;
    }

    public abstract int getMaximumCommandLength();

    public void compile(CCTask task, File outputDir, String[] sourceFiles, String[] args, String[] endArgs, boolean relentless, ProgressMonitor monitor) throws BuildException {
        BuildException exc = null;
        String command = this.getCommand();
        int baseLength = command.length() + args.length + endArgs.length;
        if (this.libtool) {
            baseLength += 8;
        }
        int i = 0;
        while (i < args.length) {
            baseLength += args[i].length();
            ++i;
        }
        int i2 = 0;
        while (i2 < endArgs.length) {
            baseLength += endArgs[i2].length();
            ++i2;
        }
        if (baseLength > this.getMaximumCommandLength()) {
            throw new BuildException("Command line is over maximum length without specifying source file");
        }
        int maxInputFilesPerCommand = this.getMaximumInputFilesPerCommand();
        int argumentCountPerInputFile = this.getArgumentCountPerInputFile();
        int sourceIndex = 0;
        while (sourceIndex < sourceFiles.length) {
            int cmdLength = baseLength;
            int firstFileNextExec = sourceIndex;
            while (firstFileNextExec < sourceFiles.length && firstFileNextExec - sourceIndex < maxInputFilesPerCommand) {
                if ((cmdLength += this.getTotalArgumentLengthForInputFile(outputDir, sourceFiles[firstFileNextExec])) >= this.getMaximumCommandLength()) break;
                ++firstFileNextExec;
            }
            if (firstFileNextExec == sourceIndex) {
                throw new BuildException("Extremely long file name, can't fit on command line");
            }
            int argCount = args.length + 1 + endArgs.length + (firstFileNextExec - sourceIndex) * argumentCountPerInputFile;
            if (this.libtool) {
                ++argCount;
            }
            String[] commandline = new String[argCount];
            int index = 0;
            if (this.libtool) {
                commandline[index++] = "libtool";
            }
            commandline[index++] = command;
            int j = 0;
            while (j < args.length) {
                commandline[index++] = args[j];
                ++j;
            }
            int j2 = sourceIndex;
            while (j2 < firstFileNextExec) {
                int k = 0;
                while (k < argumentCountPerInputFile) {
                    commandline[index++] = this.getInputFileArgument(outputDir, sourceFiles[j2], k);
                    ++k;
                }
                ++j2;
            }
            int j3 = 0;
            while (j3 < endArgs.length) {
                commandline[index++] = endArgs[j3];
                ++j3;
            }
            int retval = this.runCommand(task, outputDir, commandline);
            if (monitor != null) {
                String[] fileNames = new String[firstFileNextExec - sourceIndex];
                int j4 = 0;
                while (j4 < fileNames.length) {
                    fileNames[j4] = sourceFiles[sourceIndex + j4];
                    ++j4;
                }
                monitor.progress(fileNames);
            }
            if (retval != 0 && exc == null) {
                exc = new BuildException(this.getCommand() + " failed with return code " + retval, task.getLocation());
                if (!relentless) {
                    throw exc;
                }
            }
            sourceIndex = firstFileNextExec;
        }
        if (exc != null) {
            throw exc;
        }
    }

    protected int runCommand(CCTask task, File workingDir, String[] cmdline) throws BuildException {
        return CUtil.runCommand(task, workingDir, cmdline, this.newEnvironment, this.env);
    }

    protected abstract File[] getEnvironmentIncludePath();

    protected CompilerConfiguration createConfiguration(CCTask task, LinkType linkType, ProcessorDef[] baseDefs, CompilerDef specificDef) {
        Object[] incPath;
        String baseDirPath;
        Vector<String> args = new Vector<String>();
        CompilerDef[] defaultProviders = new CompilerDef[baseDefs.length + 1];
        int i = 0;
        while (i < baseDefs.length) {
            defaultProviders[i + 1] = (CompilerDef)baseDefs[i];
            ++i;
        }
        defaultProviders[0] = specificDef;
        Vector<CommandLineArgument> cmdArgs = new Vector<CommandLineArgument>();
        int i2 = defaultProviders.length - 1;
        while (i2 >= 0) {
            CommandLineArgument[] commandArgs = defaultProviders[i2].getActiveProcessorArgs();
            int j = 0;
            while (j < commandArgs.length) {
                if (commandArgs[j].getLocation() == 0) {
                    args.addElement(commandArgs[j].getValue());
                } else {
                    cmdArgs.addElement(commandArgs[j]);
                }
                ++j;
            }
            --i2;
        }
        boolean multithreaded = specificDef.getMultithreaded(defaultProviders, 1);
        boolean debug = specificDef.getDebug(baseDefs, 0);
        boolean exceptions = specificDef.getExceptions(defaultProviders, 1);
        this.addImpliedArgs(args, debug, multithreaded, exceptions, linkType);
        this.buildDefineArguments(defaultProviders, args);
        Vector relativeArgs = (Vector)args.clone();
        StringBuffer includePathIdentifier = new StringBuffer();
        File baseDir = specificDef.getProject().getBaseDir();
        try {
            baseDirPath = baseDir.getCanonicalPath();
        }
        catch (IOException ex) {
            baseDirPath = baseDir.toString();
        }
        Vector<Object> includePath = new Vector<Object>();
        Vector<Object> sysIncludePath = new Vector<Object>();
        int i3 = defaultProviders.length - 1;
        while (i3 >= 0) {
            incPath = defaultProviders[i3].getActiveIncludePaths();
            int j = 0;
            while (j < incPath.length) {
                includePath.addElement(incPath[j]);
                ++j;
            }
            incPath = defaultProviders[i3].getActiveSysIncludePaths();
            int j2 = 0;
            while (j2 < incPath.length) {
                sysIncludePath.addElement(incPath[j2]);
                ++j2;
            }
            --i3;
        }
        incPath = new File[includePath.size()];
        int i4 = 0;
        while (i4 < includePath.size()) {
            incPath[i4] = new File((String)includePath.elementAt(i4));
            ++i4;
        }
        File[] sysIncPath = new File[sysIncludePath.size()];
        int i5 = 0;
        while (i5 < sysIncludePath.size()) {
            sysIncPath[i5] = new File((String)sysIncludePath.elementAt(i5));
            ++i5;
        }
        this.addIncludes(baseDirPath, (File[])incPath, args, relativeArgs, includePathIdentifier);
        this.addIncludes(baseDirPath, sysIncPath, args, null, null);
        StringBuffer buf = new StringBuffer(this.getIdentifier());
        int i6 = 0;
        while (i6 < relativeArgs.size()) {
            buf.append(relativeArgs.elementAt(i6));
            buf.append(' ');
            ++i6;
        }
        buf.setLength(buf.length() - 1);
        String configId = buf.toString();
        int warnings = specificDef.getWarnings(defaultProviders, 0);
        this.addWarningSwitch(args, warnings);
        Enumeration argEnum = cmdArgs.elements();
        int endCount = 0;
        while (argEnum.hasMoreElements()) {
            CommandLineArgument arg = (CommandLineArgument)argEnum.nextElement();
            switch (arg.getLocation()) {
                case 1: {
                    args.addElement(arg.getValue());
                    break;
                }
                case 2: {
                    ++endCount;
                }
            }
        }
        String[] endArgs = new String[endCount];
        argEnum = cmdArgs.elements();
        int index = 0;
        while (argEnum.hasMoreElements()) {
            CommandLineArgument arg = (CommandLineArgument)argEnum.nextElement();
            if (arg.getLocation() != 2) continue;
            endArgs[index++] = arg.getValue();
        }
        Object[] argArray = new String[args.size()];
        args.copyInto(argArray);
        boolean rebuild = specificDef.getRebuild(baseDefs, 0);
        File[] envIncludePath = this.getEnvironmentIncludePath();
        return new CommandLineCompilerConfiguration(this, configId, (File[])incPath, sysIncPath, envIncludePath, includePathIdentifier.toString(), (String[])argArray, rebuild, endArgs);
    }

    protected void addIncludes(String baseDirPath, File[] includeDirs, Vector args, Vector relativeArgs, StringBuffer includePathId) {
        int i = 0;
        while (i < includeDirs.length) {
            args.addElement(this.getIncludeDirSwitch(includeDirs[i].getAbsolutePath()));
            if (relativeArgs != null) {
                String relative = CUtil.getRelativePath(baseDirPath, includeDirs[i]);
                relativeArgs.addElement(this.getIncludeDirSwitch(relative));
                if (includePathId != null) {
                    if (includePathId.length() == 0) {
                        includePathId.append("/I");
                    } else {
                        includePathId.append(" /I");
                    }
                    includePathId.append(relative);
                }
            }
            ++i;
        }
    }

    protected void buildDefineArguments(CompilerDef[] defs, Vector args) {
        UndefineArgument[] merged = defs[0].getActiveDefines();
        int i = 1;
        while (i < defs.length) {
            merged = UndefineArgument.merge(defs[i].getActiveDefines(), merged);
            ++i;
        }
        StringBuffer buf = new StringBuffer(30);
        int i2 = 0;
        while (i2 < merged.length) {
            buf.setLength(0);
            UndefineArgument current = merged[i2];
            if (current.isDefine()) {
                this.getDefineSwitch(buf, current.getName(), current.getValue());
            } else {
                this.getUndefineSwitch(buf, current.getName());
            }
            args.addElement(buf.toString());
            ++i2;
        }
    }

    public String getIdentifier() {
        if (this.identifier == null) {
            this.identifier = this.identifierArg == null ? AbstractProcessor.getIdentifier(new String[]{this.command}, this.command) : AbstractProcessor.getIdentifier(new String[]{this.command, this.identifierArg}, this.command);
        }
        return this.identifier;
    }
}

