/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.compiler;

import net.sf.antcontrib.cpptasks.compiler.CaptureStreamHandler;
import net.sf.antcontrib.cpptasks.compiler.Processor;
import org.apache.tools.ant.types.Environment;

public abstract class AbstractProcessor
implements Processor {
    private final String[] sourceExtensions;
    private final String[] headerExtensions;
    public static final int DEFAULT_PROCESS_BID = 100;
    public static final int DEFAULT_DISCARD_BID = 1;

    protected AbstractProcessor(String[] sourceExtensions, String[] headerExtensions) {
        this.sourceExtensions = (String[])sourceExtensions.clone();
        this.headerExtensions = (String[])headerExtensions.clone();
    }

    public abstract String getIdentifier();

    public final String toString() {
        return this.getIdentifier();
    }

    public int bid(String inputFile) {
        String lower = inputFile.toLowerCase();
        int i = 0;
        while (i < this.sourceExtensions.length) {
            if (lower.endsWith(this.sourceExtensions[i])) {
                return 100;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.headerExtensions.length) {
            if (lower.endsWith(this.headerExtensions[i2])) {
                return 1;
            }
            ++i2;
        }
        return 0;
    }

    protected static String getIdentifier(String[] command, String fallback) {
        String identifier = fallback;
        try {
            String[] cmdout = CaptureStreamHandler.run(command);
            if (cmdout.length > 0) {
                identifier = cmdout[0];
            }
        }
        catch (Throwable ex) {
            identifier = fallback + ":" + ex.toString();
        }
        return identifier;
    }

    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        return this;
    }

    public String[] getSourceExtensions() {
        return (String[])this.sourceExtensions.clone();
    }

    public String[] getHeaderExtensions() {
        return (String[])this.headerExtensions.clone();
    }

    protected String getOSName() {
        return System.getProperty("os.name");
    }

    protected String getOSArch() {
        return System.getProperty("os.arch");
    }

    protected boolean isDarwin() {
        String osName = this.getOSName();
        return "Mac OS X".equals(osName);
    }
}

