/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.borland;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.borland.BorlandCfgParser;

public final class BorlandProcessor {
    private BorlandProcessor() {
    }

    public static String getIncludeDirSwitch(String includeOption, String includeDir) {
        StringBuffer buf = new StringBuffer(includeOption);
        BorlandProcessor.quoteFile(buf, includeDir);
        return buf.toString();
    }

    public static void getDefineSwitch(StringBuffer buffer, String define, String value) {
        buffer.append("-D");
        buffer.append(define);
        if (value != null && value.length() > 0) {
            buffer.append('=');
            buffer.append(value);
        }
    }

    public static void getUndefineSwitch(StringBuffer buffer, String define) {
        buffer.append("-U");
        buffer.append(define);
    }

    public static void addWarningSwitch(Vector args, int level) {
        switch (level) {
            case 0: {
                args.addElement("-w-");
                break;
            }
            case 5: {
                args.addElement("-w!");
                break;
            }
            default: {
                args.addElement("-w");
            }
        }
    }

    public static File[] getEnvironmentPath(String toolName, char switchChar, String[] defaultRelativePath) {
        if (toolName == null) {
            throw new NullPointerException("toolName");
        }
        if (defaultRelativePath == null) {
            throw new NullPointerException("defaultRelativePath");
        }
        String[] path = defaultRelativePath;
        File exeDir = CUtil.getExecutableLocation(toolName + ".exe");
        if (exeDir != null) {
            File cfgFile = new File(exeDir, toolName + ".cfg");
            if (cfgFile.exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(cfgFile));
                    BorlandCfgParser cfgParser = new BorlandCfgParser(switchChar);
                    path = cfgParser.parsePath(reader);
                    ((Reader)reader).close();
                }
                catch (IOException ex) {}
            }
        } else {
            exeDir = new File(System.getProperty("user.dir"));
        }
        int nonExistant = 0;
        File[] resourcePath = new File[path.length];
        int i = 0;
        while (i < path.length) {
            resourcePath[i] = new File(path[i]);
            if (!resourcePath[i].isAbsolute()) {
                resourcePath[i] = new File(exeDir, path[i]);
            }
            if (!resourcePath[i].exists() || !resourcePath[i].isDirectory()) {
                resourcePath[i] = null;
                ++nonExistant;
            }
            ++i;
        }
        if (nonExistant > 0) {
            File[] culled = new File[resourcePath.length - nonExistant];
            int index = 0;
            int i2 = 0;
            while (i2 < resourcePath.length) {
                if (resourcePath[i2] != null) {
                    culled[index++] = resourcePath[i2];
                }
                ++i2;
            }
            resourcePath = culled;
        }
        return resourcePath;
    }

    private static void quoteFile(StringBuffer buf, String outPath) {
        if (outPath.indexOf(32) >= 0) {
            buf.append('\"');
            buf.append(outPath);
            buf.append('\"');
        } else {
            buf.append(outPath);
        }
    }

    public static String[] getOutputFileSwitch(String outFile) {
        StringBuffer buf = new StringBuffer("-fo");
        BorlandProcessor.quoteFile(buf, outFile);
        String[] retval = new String[]{buf.toString()};
        return retval;
    }

    public static String getCommandFileSwitch(String cmdFile) {
        StringBuffer buf = new StringBuffer("@");
        BorlandProcessor.quoteFile(buf, cmdFile);
        return buf.toString();
    }

    public static String[] getLibraryPatterns(String[] libnames) {
        StringBuffer buf = new StringBuffer();
        String[] patterns = new String[libnames.length];
        int i = 0;
        while (i < libnames.length) {
            buf.setLength(0);
            buf.append(libnames[i]);
            buf.append(".lib");
            patterns[i] = buf.toString();
            ++i;
        }
        return patterns;
    }

    public static boolean isCaseSensitive() {
        return false;
    }
}

