/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.borland;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.borland.BorlandLibrarian;
import net.sf.antcontrib.cpptasks.borland.BorlandProcessor;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinker;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinkerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;

public final class BorlandLinker
extends CommandLineLinker {
    private static final BorlandLinker instance = new BorlandLinker(".exe");
    private static final BorlandLinker dllLinker = new BorlandLinker(".dll");

    private BorlandLinker(String outputSuffix) {
        super("ilink32", "/bogus", new String[]{".obj", ".lib", ".res"}, new String[]{".map", ".pdb", ".lnk"}, outputSuffix, false, null);
    }

    public static BorlandLinker getInstance() {
        return instance;
    }

    public String[] getOutputFileSwitch(String outFile) {
        return BorlandProcessor.getOutputFileSwitch(outFile);
    }

    public File[] getLibraryPath() {
        return BorlandProcessor.getEnvironmentPath("ilink32", 'L', new String[]{"..\\lib"});
    }

    protected void addFixed(Boolean fixed, Vector args) {
    }

    protected void addMap(boolean map, Vector args) {
        if (!map) {
            args.addElement("-x");
        }
    }

    protected void addBase(long base, Vector args) {
        if (base >= 0L) {
            String baseAddr = Long.toHexString(base);
            args.addElement("-b:" + baseAddr);
        }
    }

    protected void addStack(int stack, Vector args) {
        if (stack >= 0) {
            String stackStr = Integer.toHexString(stack);
            args.addElement("-S:" + stackStr);
        }
    }

    public Linker getLinker(LinkType type) {
        if (type.isStaticLibrary()) {
            return BorlandLibrarian.getInstance();
        }
        if (type.isSharedLibrary()) {
            return dllLinker;
        }
        return instance;
    }

    protected String getStartupObject(LinkType linkType) {
        if (linkType.isSharedLibrary()) {
            return "c0d32.obj";
        }
        if (linkType.isSubsystemGUI()) {
            return "c0w32.obj";
        }
        if (linkType.isSubsystemConsole()) {
            return "c0x32.obj";
        }
        return null;
    }

    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
        if (linkType.isExecutable()) {
            if (linkType.isSubsystemConsole()) {
                args.addElement("/ap");
            } else if (linkType.isSubsystemGUI()) {
                args.addElement("/Tpe");
            }
        }
        if (linkType.isSharedLibrary()) {
            args.addElement("/Tpd");
        }
    }

    public String getCommandFileSwitch(String commandFile) {
        return "@" + commandFile;
    }

    public int getMaximumCommandLength() {
        return 1024;
    }

    protected String[] prepareArguments(String outputDir, String outputName, String[] sourceFiles, CommandLineLinkerConfiguration config) {
        String[] preargs = config.getPreArguments();
        String[] endargs = config.getEndArguments();
        Vector<String> execArgs = new Vector<String>(preargs.length + endargs.length + 10 + sourceFiles.length);
        execArgs.addElement(this.getCommand());
        int i = 0;
        while (i < preargs.length) {
            execArgs.addElement(preargs[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < endargs.length) {
            execArgs.addElement(endargs[i2]);
            ++i2;
        }
        String startup = null;
        int i3 = 0;
        while (i3 < sourceFiles.length) {
            String filename = new File(sourceFiles[i3]).getName().toLowerCase();
            if (startup != null && filename.substring(0, 2).equals("c0") && filename.substring(3, 5).equals("32") && filename.substring(filename.length() - 4).equals(".obj")) {
                startup = sourceFiles[i3];
            }
            ++i3;
        }
        if (startup == null) {
            startup = config.getStartupObject();
        }
        execArgs.addElement(startup);
        Vector<String> resFiles = new Vector<String>();
        Vector<String> libFiles = new Vector<String>();
        String defFile = null;
        StringBuffer buf = new StringBuffer();
        int i4 = 0;
        while (i4 < sourceFiles.length) {
            String last4 = sourceFiles[i4].substring(sourceFiles[i4].length() - 4).toLowerCase();
            if (last4.equals(".def")) {
                defFile = this.quoteFilename(buf, sourceFiles[i4]);
            } else if (last4.equals(".res")) {
                resFiles.addElement(this.quoteFilename(buf, sourceFiles[i4]));
            } else if (last4.equals(".lib")) {
                libFiles.addElement(this.quoteFilename(buf, sourceFiles[i4]));
            } else {
                execArgs.addElement(this.quoteFilename(buf, sourceFiles[i4]));
            }
            ++i4;
        }
        String outputFileName = new File(outputDir, outputName).toString();
        execArgs.addElement("," + this.quoteFilename(buf, outputFileName));
        if (config.getMap()) {
            int lastPeriod = outputFileName.lastIndexOf(46);
            String mapName = lastPeriod < outputFileName.length() - 4 ? outputFileName + ".map" : outputFileName.substring(0, lastPeriod) + ".map";
            execArgs.addElement("," + this.quoteFilename(buf, mapName) + ",");
        } else {
            execArgs.addElement(",,");
        }
        Enumeration libEnum = libFiles.elements();
        while (libEnum.hasMoreElements()) {
            String libName = (String)libEnum.nextElement();
            execArgs.addElement(this.quoteFilename(buf, libName));
        }
        if (defFile == null) {
            execArgs.addElement(",,");
        } else {
            execArgs.addElement("," + this.quoteFilename(buf, defFile) + ",");
        }
        Enumeration resEnum = resFiles.elements();
        while (resEnum.hasMoreElements()) {
            String resName = (String)resEnum.nextElement();
            execArgs.addElement(this.quoteFilename(buf, resName));
        }
        Object[] execArguments = new String[execArgs.size()];
        execArgs.copyInto(execArguments);
        return execArguments;
    }

    protected String[] prepareResponseFile(File outputFile, String[] args) throws IOException {
        String baseName = CUtil.getBasename(outputFile);
        File commandFile = new File(outputFile.getParent(), baseName + ".lnk");
        FileWriter writer = new FileWriter(commandFile);
        int i = 1;
        while (i < args.length - 1) {
            writer.write(args[i]);
            if (args[i].endsWith(",") || args[i + 1].startsWith(",")) {
                writer.write(32);
            } else {
                writer.write(" + \n");
            }
            ++i;
        }
        if (args.length > 1) {
            writer.write(args[args.length - 1]);
        }
        writer.close();
        String[] execArgs = new String[]{args[0], this.getCommandFileSwitch(commandFile.toString())};
        return execArgs;
    }

    public String[] getLibraryPatterns(String[] libnames) {
        return BorlandProcessor.getLibraryPatterns(libnames);
    }

    protected void addIncremental(boolean incremental, Vector args) {
    }

    public boolean isCaseSensitive() {
        return BorlandProcessor.isCaseSensitive();
    }
}

