/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;

public class CUtil {
    public static String[] toArray(Vector src) {
        Object[] retval = new String[src.size()];
        src.copyInto(retval);
        return retval;
    }

    public static void addAll(Vector dest, Object[] src) {
        if (src == null) {
            return;
        }
        int i = 0;
        while (i < src.length) {
            dest.addElement(src[i]);
            ++i;
        }
    }

    public static String getBasename(File file) {
        String path = file.getPath();
        String basename = file.getName();
        int pos = basename.lastIndexOf(46);
        if (pos != -1) {
            basename = basename.substring(0, pos);
        }
        return basename;
    }

    public static String getParentPath(String path) {
        int pos = path.lastIndexOf(File.separator);
        if (pos <= 0) {
            return null;
        }
        return path.substring(0, pos);
    }

    public static boolean sameSet(Object[] a, Vector b) {
        if (a == null || b == null || a.length != b.size()) {
            return false;
        }
        if (a.length == 0) {
            return true;
        }
        Hashtable<Object, Object> t = new Hashtable<Object, Object>();
        int i = 0;
        while (i < a.length) {
            t.put(a[i], a[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < b.size()) {
            Object o = b.elementAt(i2);
            if (t.remove(o) == null) {
                return false;
            }
            ++i2;
        }
        return t.size() == 0;
    }

    public static boolean sameList(Object[] a, Object[] b) {
        if (a == null || b == null || a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (!a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean sameList(Vector v, Object[] a) {
        if (v == null || a == null || v.size() != a.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            Object o = a[i];
            if (!o.equals(v.elementAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getRelativePath(String base, File targetFile) {
        try {
            String prefix2;
            int endPrefix;
            String prefix1;
            String canonicalTarget;
            String canonicalBase = base;
            if (base.charAt(base.length() - 1) == File.separatorChar) {
                canonicalBase = base.substring(0, base.length() - 1);
            }
            if ((canonicalTarget = System.getProperty("os.name").equals("OS/400") ? targetFile.getPath() : targetFile.getCanonicalPath()).charAt(canonicalTarget.length() - 1) == File.separatorChar) {
                canonicalTarget = canonicalTarget.substring(0, canonicalTarget.length() - 1);
            }
            if (canonicalTarget.equals(canonicalBase)) {
                return ".";
            }
            if (canonicalBase.substring(0, 2).equals("\\\\") ? !(prefix1 = canonicalBase.substring(0, endPrefix = canonicalBase.indexOf(92, 2))).equals(prefix2 = canonicalTarget.substring(0, endPrefix)) : (canonicalBase.substring(1, 3).equals(":\\") ? !(prefix1 = canonicalBase.substring(0, endPrefix = 2)).equals(prefix2 = canonicalTarget.substring(0, endPrefix)) : canonicalBase.charAt(0) == '/' && canonicalTarget.charAt(0) != '/')) {
                return canonicalTarget;
            }
            char separator = File.separatorChar;
            int lastSeparator = -1;
            int minLength = canonicalBase.length();
            if (canonicalTarget.length() < minLength) {
                minLength = canonicalTarget.length();
            }
            int firstDifference = minLength + 1;
            int i = 0;
            while (i < minLength) {
                if (canonicalTarget.charAt(i) == canonicalBase.charAt(i)) {
                    if (canonicalTarget.charAt(i) == separator) {
                        lastSeparator = i;
                    }
                } else {
                    firstDifference = lastSeparator + 1;
                    break;
                }
                ++i;
            }
            StringBuffer relativePath = new StringBuffer(50);
            if (canonicalBase.length() > firstDifference) {
                relativePath.append("..");
                int i2 = firstDifference;
                while (i2 < canonicalBase.length()) {
                    if (canonicalBase.charAt(i2) == separator) {
                        relativePath.append(separator);
                        relativePath.append("..");
                    }
                    ++i2;
                }
            }
            if (canonicalTarget.length() > firstDifference) {
                if (relativePath.length() > 0) {
                    relativePath.append(separator);
                }
                relativePath.append(canonicalTarget.substring(firstDifference));
            }
            return relativePath.toString();
        }
        catch (IOException ex) {
            return targetFile.toString();
        }
    }

    public static String xmlAttribEncode(String attrValue) {
        int quotePos = attrValue.indexOf(34);
        if (quotePos < 0) {
            return attrValue;
        }
        int startPos = 0;
        StringBuffer buf = new StringBuffer(attrValue.length() + 20);
        while (quotePos >= 0) {
            buf.append(attrValue.substring(startPos, quotePos));
            buf.append("&quot;");
            startPos = quotePos + 1;
            quotePos = attrValue.indexOf(34, startPos);
        }
        buf.append(attrValue.substring(startPos));
        return buf.toString();
    }

    public static File[] getPathFromEnvironment(String envVariable, String delim) {
        if (System.getProperty("os.name").equals("OS/400")) {
            return new File[0];
        }
        Vector osEnv = Execute.getProcEnvironment();
        String match = envVariable.concat("=");
        Enumeration e = osEnv.elements();
        while (e.hasMoreElements()) {
            String entryFrag;
            String entry = ((String)e.nextElement()).trim();
            if (entry.length() <= match.length() || !(entryFrag = entry.substring(0, match.length())).equalsIgnoreCase(match)) continue;
            String path = entry.substring(match.length());
            return CUtil.parsePath(path, delim);
        }
        File[] noPath = new File[]{};
        return noPath;
    }

    public static File getExecutableLocation(String exeName) {
        File currentDir = new File(System.getProperty("user.dir"));
        if (new File(currentDir, exeName).exists()) {
            return currentDir;
        }
        File[] envPath = CUtil.getPathFromEnvironment("path", ";");
        int i = 0;
        while (i < envPath.length) {
            if (new File(envPath[i], exeName).exists()) {
                return envPath[i];
            }
            ++i;
        }
        return null;
    }

    public static File[] parsePath(String path, String delim) {
        Vector<File> libpaths = new Vector<File>();
        int delimPos = 0;
        int startPos = 0;
        while (startPos < path.length()) {
            String dirName;
            File dir;
            delimPos = path.indexOf(delim, startPos);
            if (delimPos < 0) {
                delimPos = path.length();
            }
            if (delimPos > startPos && (dir = new File(dirName = path.substring(startPos, delimPos))).exists() && dir.isDirectory()) {
                libpaths.addElement(dir);
            }
            startPos = delimPos + delim.length();
        }
        Object[] paths = new File[libpaths.size()];
        libpaths.copyInto(paths);
        return paths;
    }

    public static int checkDirectoryArray(String[] names) {
        int count = 0;
        int i = 0;
        while (i < names.length) {
            if (names[i] != null) {
                File dir = new File(names[i]);
                if (dir.exists() && dir.isDirectory()) {
                    ++count;
                } else {
                    names[i] = null;
                }
            }
            ++i;
        }
        return count;
    }

    public static int runCommand(CCTask task, File workingDir, String[] cmdline, boolean newEnvironment, Environment env) throws BuildException {
        try {
            task.log(Commandline.toString((String[])cmdline), 3);
            Execute exe = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)task, 2, 0));
            if (System.getProperty("os.name").equals("OS/390")) {
                exe.setVMLauncher(false);
            }
            exe.setAntRun(task.getProject());
            exe.setCommandline(cmdline);
            exe.setWorkingDirectory(workingDir);
            if (env != null) {
                String[] environment = env.getVariables();
                if (environment != null) {
                    int i = 0;
                    while (i < environment.length) {
                        task.log("Setting environment variable: " + environment[i], 3);
                        ++i;
                    }
                }
                exe.setEnvironment(environment);
            }
            exe.setNewenvironment(newEnvironment);
            return exe.execute();
        }
        catch (IOException exc) {
            throw new BuildException("Could not launch " + cmdline[0] + ": " + exc, task.getLocation());
        }
    }

    public static boolean isActive(Project p, String ifCond, String unlessCond) throws BuildException {
        String unlessValue;
        if (ifCond != null) {
            String ifValue = p.getProperty(ifCond);
            if (ifValue == null) {
                return false;
            }
            if (ifValue.equals("false") || ifValue.equals("no")) {
                throw new BuildException("if condition \"" + ifCond + "\" has suspicious value \"" + ifValue);
            }
        }
        if (unlessCond != null && (unlessValue = p.getProperty(unlessCond)) != null) {
            if (unlessValue.equals("false") || unlessValue.equals("no")) {
                throw new BuildException("unless condition \"" + unlessCond + "\" has suspicious value \"" + unlessValue);
            }
            return false;
        }
        return true;
    }

    public static final class StringArrayBuilder {
        private String[] _value;

        public StringArrayBuilder(String value) {
            StringTokenizer tokens = new StringTokenizer(value, ", ");
            Vector<String> vallist = new Vector<String>();
            while (tokens.hasMoreTokens()) {
                String val = tokens.nextToken().trim();
                if (val.length() == 0) continue;
                vallist.addElement(val);
            }
            this._value = new String[vallist.size()];
            vallist.copyInto(this._value);
        }

        public String[] getValue() {
            return this._value;
        }
    }
}

