/*
 * Decompiled with CFR 0.152.
 */
package am.ik.voicetext4j.http;

import am.ik.voicetext4j.http.VoiceTextApiCallException;
import am.ik.voicetext4j.http.VoiceTextFields;
import am.ik.voicetext4j.http.VoiceTextIllegalStateException;
import am.ik.voicetext4j.http.VoiceTextResponse;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.xml.bind.DatatypeConverter;

public class VoiceTextUrlConnectionClient {
    static final int CONNECT_TIMEOUT_MILLIS = 15000;
    static final int READ_TIMEOUT_MILLIS = 20000;
    static final int CHUNK_SIZE = 4096;
    static final String API_ENDPOINT = System.getProperty("voicetext.endpoint", "https://api.voicetext.jp/v1/tts");

    HttpURLConnection openConnection() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(API_ENDPOINT).openConnection();
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(20000);
        return connection;
    }

    void prepareRequest(HttpURLConnection connection, VoiceTextFields fieldsBuilder) throws IOException {
        connection.setRequestMethod("POST");
        connection.setChunkedStreamingMode(4096);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        connection.setRequestProperty("User-Agent", "VoiceText4J");
        connection.setDoOutput(true);
        connection.getOutputStream().write(fieldsBuilder.getBody());
    }

    AudioInputStream readResponse(HttpURLConnection connection) throws IOException {
        int status = connection.getResponseCode();
        String reason = connection.getResponseMessage();
        if (reason == null) {
            reason = "";
        }
        if (status >= 400) {
            throw new VoiceTextApiCallException(status, reason);
        }
        InputStream stream = connection.getInputStream();
        try {
            return AudioSystem.getAudioInputStream(new BufferedInputStream(stream));
        }
        catch (UnsupportedAudioFileException e) {
            throw new VoiceTextIllegalStateException(e);
        }
    }

    public VoiceTextResponse execute(VoiceTextFields fields, String apiKey) {
        try {
            HttpURLConnection connection = this.openConnection();
            connection.setRequestProperty("Authorization", "Basic " + DatatypeConverter.printBase64Binary((byte[])(apiKey + ":").getBytes()));
            this.prepareRequest(connection, fields);
            return new VoiceTextResponse(this.readResponse(connection));
        }
        catch (IOException e) {
            throw new VoiceTextIllegalStateException(e);
        }
    }
}

