/*
 * Decompiled with CFR 0.152.
 */
package am.ik.voicetext4j.http;

import am.ik.voicetext4j.http.VoiceTextIllegalStateException;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;

public class VoiceTextResponse {
    final AudioInputStream audioInputStream;

    public VoiceTextResponse(AudioInputStream audioInputStream) {
        this.audioInputStream = audioInputStream;
    }

    public AudioInputStream audioInputStream() {
        return this.audioInputStream;
    }

    public Clip clip() {
        AudioFormat format = this.audioInputStream.getFormat();
        DataLine.Info info = new DataLine.Info(Clip.class, format);
        try {
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(this.audioInputStream);
            return clip;
        }
        catch (IOException | LineUnavailableException e) {
            throw new VoiceTextIllegalStateException(e);
        }
    }

    public CompletableFuture<Void> play() {
        Clip clip = this.clip();
        CompletionStage future = new CompletableFuture().whenComplete((x, e) -> clip.close());
        clip.addLineListener(arg_0 -> VoiceTextResponse.lambda$play$1((CompletableFuture)future, arg_0));
        clip.start();
        return future;
    }

    private static /* synthetic */ void lambda$play$1(CompletableFuture future, LineEvent event) {
        if (event.getType() == LineEvent.Type.STOP) {
            future.complete(null);
        }
    }
}

