/*
 * Decompiled with CFR 0.152.
 */
package am.ik.voicetext4j.http;

import am.ik.voicetext4j.http.VoiceTextIllegalStateException;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;

public class VoiceTextResponse {
    final AudioInputStream audioInputStream;

    public VoiceTextResponse(AudioInputStream audioInputStream) {
        this.audioInputStream = audioInputStream;
    }

    public AudioInputStream audioInputStream() {
        return this.audioInputStream;
    }

    public Clip clip() {
        AudioFormat format = this.audioInputStream.getFormat();
        DataLine.Info info = new DataLine.Info(Clip.class, format);
        try {
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(this.audioInputStream);
            return clip;
        }
        catch (IOException | LineUnavailableException e) {
            throw new VoiceTextIllegalStateException(e);
        }
    }

    public void play() {
        Clip clip = this.clip();
        clip.start();
        final CountDownLatch latch = new CountDownLatch(1);
        clip.addLineListener(new LineListener(){

            @Override
            public void update(LineEvent event) {
                if (event.getType() == LineEvent.Type.STOP) {
                    latch.countDown();
                }
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        clip.close();
    }
}

