/*
 * Decompiled with CFR 0.152.
 */
package am.ik.voicetext4j;

import am.ik.voicetext4j.http.VoiceTextFields;
import am.ik.voicetext4j.http.VoiceTextResponse;
import am.ik.voicetext4j.http.VoiceTextUrlConnectionClient;
import java.io.Serializable;

public abstract class VoiceContext<T extends VoiceContext>
implements Serializable {
    final String speaker;
    int pitch = 100;
    int speed = 100;
    int volume = 100;

    public VoiceContext(String speaker) {
        this.speaker = speaker;
    }

    public T pitch(int pitch) {
        if (pitch < 50 || pitch > 200) {
            throw new IllegalArgumentException("'pitch' must be between 50 and 200.");
        }
        this.pitch = pitch;
        return (T)this;
    }

    public T speed(int speed) {
        if (speed < 50 || speed > 400) {
            throw new IllegalArgumentException("'speed' must be between 50 and 400.");
        }
        this.speed = speed;
        return (T)this;
    }

    public T volume(int volume) {
        if (volume < 50 || volume > 200) {
            throw new IllegalArgumentException("'volume' must be between 50 and 200.");
        }
        this.volume = volume;
        return (T)this;
    }

    protected VoiceTextFields build() {
        return new VoiceTextFields().put("speaker", this.speaker).put("pitch", String.valueOf(this.pitch)).put("speed", String.valueOf(this.speed)).put("volume", String.valueOf(this.volume));
    }

    public VoiceTextResponse getResponse(String text, String apiKey) {
        if (text == null || text.length() < 1 || text.length() > 200) {
            throw new IllegalArgumentException("the length of 'text' must be between 1 and 200.");
        }
        if (apiKey == null || apiKey.isEmpty()) {
            throw new IllegalArgumentException("'apiKey' is required.");
        }
        VoiceTextFields fields = this.build().put("text", text);
        return new VoiceTextUrlConnectionClient().execute(fields, apiKey);
    }

    public VoiceTextResponse getResponse(String text) {
        return this.getResponse(text, System.getProperty("voicetext.apikey"));
    }

    public void speak(String text, String apiKey) throws InterruptedException {
        this.getResponse(text, apiKey).play();
    }

    public void speak(String text) {
        this.getResponse(text).play();
    }
}

