/*
 * Decompiled with CFR 0.152.
 */
package am.ik.voicetext4j;

import am.ik.voicetext4j.Emotion;
import am.ik.voicetext4j.VoiceContext;
import am.ik.voicetext4j.http.VoiceTextFields;

public class EmotionalVoiceContext
extends VoiceContext<EmotionalVoiceContext> {
    Emotion emotion;
    Emotion.Level emotionLevel = Emotion.Level.NORMAL;

    public EmotionalVoiceContext(String speaker) {
        super(speaker);
    }

    public EmotionalVoiceContext emotion(Emotion emotion, Emotion.Level level) {
        this.emotion = emotion;
        this.emotionLevel = level;
        return this;
    }

    public EmotionalVoiceContext emotion(Emotion emotion) {
        this.emotion = emotion;
        return this;
    }

    @Override
    protected VoiceTextFields build() {
        VoiceTextFields fields = super.build();
        if (this.emotion != null) {
            fields.put("emotion", this.emotion.name().toLowerCase()).put("emotion_level", String.valueOf(this.emotionLevel.value()));
        }
        return fields;
    }

    public EmotionContext very() {
        return new EmotionContext(this, Emotion.Level.HIGH);
    }

    public EmotionalVoiceContext angry() {
        if (this.emotion != null) {
            throw new IllegalArgumentException("'emotion' is already set.");
        }
        return new EmotionContext(this).angry();
    }

    public EmotionalVoiceContext happy() {
        if (this.emotion != null) {
            throw new IllegalArgumentException("'emotion' is already set.");
        }
        return new EmotionContext(this).happy();
    }

    public EmotionalVoiceContext sad() {
        if (this.emotion != null) {
            throw new IllegalArgumentException("'emotion' is already set.");
        }
        return new EmotionContext(this).sad();
    }

    public class EmotionContext {
        final EmotionalVoiceContext voiceContext;

        public EmotionContext(EmotionalVoiceContext voiceContext, Emotion.Level emotionLevel) {
            this.voiceContext = voiceContext;
            voiceContext.emotionLevel = emotionLevel;
        }

        public EmotionContext(EmotionalVoiceContext voiceContext) {
            this(voiceContext, Emotion.Level.NORMAL);
        }

        public EmotionalVoiceContext angry() {
            this.voiceContext.emotion = Emotion.ANGER;
            return this.voiceContext;
        }

        public EmotionalVoiceContext happy() {
            this.voiceContext.emotion = Emotion.HAPPINESS;
            return this.voiceContext;
        }

        public EmotionalVoiceContext sad() {
            this.voiceContext.emotion = Emotion.SADNESS;
            return this.voiceContext;
        }
    }
}

