/*
 * Decompiled with CFR 0.152.
 */
package am.ik.servicebroker.mysql.servicebroker;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/service_instances/{instanceId}"})
public class ServiceInstanceController {
    private static final Logger log = LoggerFactory.getLogger(ServiceInstanceController.class);
    private final JdbcTemplate jdbcTemplate;

    public ServiceInstanceController(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @PutMapping
    @Transactional
    public ResponseEntity<Map<String, Object>> provisioning(@PathVariable(value="instanceId") String instanceId) {
        log.info("Provisioning instanceId={}", (Object)instanceId);
        Integer count = (Integer)this.jdbcTemplate.queryForObject("SELECT COUNT(*) FROM service_instance WHERE instance_id = ?", Integer.class, new Object[]{instanceId});
        HashMap body = new HashMap();
        if (count != null && count > 0) {
            return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).body(body);
        }
        String dbName = "cf_" + UUID.randomUUID().toString().replace("-", "");
        this.jdbcTemplate.execute("CREATE DATABASE IF NOT EXISTS " + dbName);
        this.jdbcTemplate.update("INSERT INTO service_instance(instance_id, db_name) VALUES(?, ?)", new Object[]{instanceId, dbName});
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body(body);
    }

    @PatchMapping
    public ResponseEntity<Map<String, Object>> update(@PathVariable(value="instanceId") String instanceId) {
        HashMap body = new HashMap();
        return ResponseEntity.ok(body);
    }

    @DeleteMapping
    @Transactional
    public ResponseEntity<Map<String, Object>> deprovisioning(@PathVariable(value="instanceId") String instanceId) {
        log.info("Deprovisioning instanceId={}", (Object)instanceId);
        HashMap body = new HashMap();
        Integer count = (Integer)this.jdbcTemplate.queryForObject("SELECT COUNT(*) FROM service_instance WHERE instance_id = ?", Integer.class, new Object[]{instanceId});
        if (count != null && count == 0) {
            return ResponseEntity.status((HttpStatus)HttpStatus.GONE).body(body);
        }
        String dbName = (String)this.jdbcTemplate.queryForObject("SELECT db_name FROM service_instance WHERE instance_id = ?", String.class, new Object[]{instanceId});
        this.jdbcTemplate.update("DELETE FROM service_instance WHERE instance_id = ?", new Object[]{instanceId});
        this.jdbcTemplate.execute("DROP DATABASE IF EXISTS " + dbName);
        return ResponseEntity.ok(body);
    }
}

