/*
 * Decompiled with CFR 0.152.
 */
package am.ik.servicebroker.mysql.config;

import am.ik.servicebroker.mysql.config.SharedMysql;
import com.zaxxer.hikari.HikariConfig;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class SharedMysql {
    private final HikariConfig hikariConfig;

    public SharedMysql(HikariConfig hikariConfig) {
        this.hikariConfig = hikariConfig;
    }

    public Credentials credentials(String name, String username, String password) {
        String uri = this.hikariConfig.getJdbcUrl().replace("jdbc:", "");
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)uri);
        UriComponents components = builder.build();
        int port = components.getPort() == -1 ? 3306 : components.getPort();
        Credentials credentials = new Credentials();
        credentials.setHostname(components.getHost());
        credentials.setPort(port);
        credentials.setName(name);
        credentials.setUsername(username);
        credentials.setPassword(password);
        credentials.setUri(builder.cloneBuilder().userInfo(username + ":" + password).port(port).replacePath(name).queryParam("reconnect", new Object[]{"true"}).build().toUriString());
        credentials.setJdbcUrl("jdbc:" + builder.cloneBuilder().port(port).replacePath(name).queryParam("user", new Object[]{username}).queryParam("password", new Object[]{password}).build().toUriString());
        return credentials;
    }
}

