/*
 * Decompiled with CFR 0.152.
 */
package am.ik.servicebroker.cloudkarafka.cloudkarafka;

import am.ik.servicebroker.cloudkarafka.cloudkarafka.CloudKarafka;
import am.ik.servicebroker.cloudkarafka.cloudkarafka.CloudKarafkaInstance;
import am.ik.servicebroker.cloudkarafka.cloudkarafka.CloudKarafkaPlan;
import am.ik.servicebroker.cloudkarafka.cloudkarafka.CloudKarafkaRegion;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class CloudKarafkaClient {
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;

    public CloudKarafkaClient(CloudKarafka cloudKarafka, RestTemplateBuilder builder, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.restTemplate = builder.basicAuthorization(cloudKarafka.getApiKey(), "").rootUri(cloudKarafka.getUri()).build();
    }

    public List<CloudKarafkaInstance> listInstances() {
        LinkedCaseInsensitiveMap[] instances = (LinkedCaseInsensitiveMap[])this.restTemplate.getForObject("/api/instances", LinkedCaseInsensitiveMap[].class, new Object[0]);
        return instances == null ? Collections.emptyList() : Arrays.stream(instances).map(arg_0 -> this.caseInsensitiveConvert(arg_0)).collect(Collectors.toList());
    }

    public CloudKarafkaInstance getInstance(Integer id) {
        LinkedCaseInsensitiveMap json = (LinkedCaseInsensitiveMap)this.restTemplate.getForObject("/api/instances/{id}", LinkedCaseInsensitiveMap.class, new Object[]{id});
        return this.caseInsensitiveConvert(json);
    }

    public CloudKarafkaInstance createInstance(String name, CloudKarafkaPlan plan, CloudKarafkaRegion region) {
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"name", (Object)name);
        body.add((Object)"plan", (Object)plan.toString());
        body.add((Object)"region", (Object)region.toString());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedCaseInsensitiveMap json = (LinkedCaseInsensitiveMap)this.restTemplate.exchange("/api/instances", HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)headers), LinkedCaseInsensitiveMap.class, new Object[0]).getBody();
        return this.caseInsensitiveConvert(json);
    }

    public Optional<CloudKarafkaInstance> findByName(String name) {
        return this.listInstances().stream().map(i -> this.getInstance(i.getId())).filter(i -> Objects.equals(name, i.getName())).findAny();
    }

    public void deleteInstance(Integer id) {
        this.restTemplate.delete("/api/instances/{id}", new Object[]{id});
    }

    CloudKarafkaInstance caseInsensitiveConvert(LinkedCaseInsensitiveMap json) {
        CloudKarafkaInstance instance = new CloudKarafkaInstance();
        instance.setId((Integer)json.get((Object)"id"));
        instance.setName((String)json.get((Object)"name"));
        instance.setPlan(CloudKarafkaPlan.of((String)((String)json.get((Object)"plan"))));
        instance.setRegion(CloudKarafkaRegion.of((String)((String)json.get((Object)"region"))));
        instance.setCa((String)json.get((Object)"ca"));
        instance.setBrokers((String)json.get((Object)"brokers"));
        instance.setPassword((String)json.get((Object)"password"));
        instance.setUsername((String)json.get((Object)"username"));
        instance.setTopicPrefix((String)json.get((Object)"topic_prefix"));
        return instance;
    }
}

