/*
 * Decompiled with CFR 0.152.
 */
package am.ik.eureka;

import com.google.inject.Singleton;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EurekaRegistrar {
    private static final Logger log = LoggerFactory.getLogger(EurekaRegistrar.class);

    @Inject
    public EurekaRegistrar(ApplicationInfoManager applicationInfoManager, EurekaClient eurekaClient, InstanceInfo instanceInfo) {
        log.info("Registering to Eureka Server");
        log.info("Application Name = {}", (Object)instanceInfo.getAppName());
        log.info("Port = {}", (Object)instanceInfo.getPort());
        log.info("VIP = {}", (Object)instanceInfo.getVIPAddress());
        log.info("Metadata = {}", (Object)instanceInfo.getMetadata());
        log.info("Set instance status to UP");
        applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.UP);
        log.info("Registered");
    }
}

