/*
 * Decompiled with CFR 0.152.
 */
package am.ik.eureka;

import com.netflix.appinfo.PropertiesInstanceConfig;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaInstanceConfigImpl
extends PropertiesInstanceConfig {
    private static final Logger log = LoggerFactory.getLogger(EurekaInstanceConfigImpl.class);

    public String getAppname() {
        String appname = super.getAppname();
        log.debug("getAppname()={}", (Object)appname);
        return appname;
    }

    public int getNonSecurePort() {
        int nonSecurePort = this.getPort().orElseGet(() -> Optional.ofNullable(System.getenv("EUREKA_INSTANCE_NON_SECURE_PORT")).map(Integer::parseInt).orElseGet(() -> super.getNonSecurePort()));
        log.debug("getNonSecurePort()={}", (Object)nonSecurePort);
        return nonSecurePort;
    }

    private Optional<Integer> getPort() {
        return Optional.ofNullable(System.getenv("PORT")).map(Integer::valueOf);
    }

    public String getInstanceId() {
        String instanceId = Optional.ofNullable(System.getenv("INSTANCE_GUID")).orElseGet(this::getInstanceId);
        log.debug("getInstanceId()={}", (Object)instanceId);
        return instanceId;
    }

    public String getHostName(boolean refresh) {
        String cfInstanceInternalIp = System.getenv("CF_INSTANCE_INTERNAL_IP");
        String hostname = Optional.ofNullable(System.getenv("EUREKA_INSTANCE_HOSTNAME")).orElseGet(() -> cfInstanceInternalIp == null ? super.getHostName(refresh) : cfInstanceInternalIp);
        log.debug("getHostName({})={}", (Object)refresh, (Object)hostname);
        return hostname;
    }

    public String getVirtualHostName() {
        String virtualHostName = Optional.ofNullable(System.getenv("EUREKA_INSTANCE_VIRTUAL_HOST_NAME")).orElseGet(this::getAppname);
        log.debug("getVirtualHostName()={}", (Object)virtualHostName);
        return virtualHostName;
    }

    public int getLeaseRenewalIntervalInSeconds() {
        int seconds = Optional.ofNullable(System.getenv("EUREKA_INSTANCE_LEASE_RENEWAL_INTERVAL_IN_SECONDS")).map(Integer::parseInt).orElseGet(() -> super.getLeaseRenewalIntervalInSeconds());
        log.debug("getLeaseRenewalIntervalInSeconds()={}", (Object)seconds);
        return seconds;
    }

    public int getLeaseExpirationDurationInSeconds() {
        int seconds = Optional.ofNullable(System.getenv("EUREKA_INSTANCE_LEASE_EXPIRATION_DURATION_IN_SECONDS")).map(Integer::parseInt).orElseGet(() -> super.getLeaseExpirationDurationInSeconds());
        log.debug("getLeaseExpirationDurationInSeconds()={}", (Object)seconds);
        return seconds;
    }

    public boolean isInstanceEnabledOnit() {
        return true;
    }
}

