/*
 * Decompiled with CFR 0.152.
 */
package am.ik.eureka;

import com.netflix.discovery.DefaultEurekaClientConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaClientConfigImpl
extends DefaultEurekaClientConfig {
    private static final Logger log = LoggerFactory.getLogger(EurekaClientConfigImpl.class);

    public List<String> getEurekaServerServiceUrls(String myZone) {
        String envKey = "EUREKA_CLIENT_SERVICE_URL_" + myZone.toUpperCase();
        List eurekaServerServiceUrls = Optional.ofNullable(System.getenv(envKey)).map(s -> Arrays.asList(s.split(","))).orElseGet(() -> super.getEurekaServerServiceUrls(myZone));
        log.debug("getEurekaServerServiceUrls({})={}", (Object)myZone, (Object)eurekaServerServiceUrls);
        return eurekaServerServiceUrls;
    }

    public int getRegistryFetchIntervalSeconds() {
        int seconds = Optional.ofNullable(System.getenv("EUREKA_CLIENT_REGISTRY_FETCH_INTERVAL_SECONDS")).map(Integer::parseInt).orElseGet(() -> super.getRegistryFetchIntervalSeconds());
        log.debug("getRegistryFetchIntervalSeconds()={}", (Object)seconds);
        return seconds;
    }

    public int getInstanceInfoReplicationIntervalSeconds() {
        int seconds = Optional.ofNullable(System.getenv("EUREKA_CLIENT_INSTANCE_INFO_REPLICATION_INTERVAL_SECONDS")).map(Integer::parseInt).orElseGet(() -> super.getInstanceInfoReplicationIntervalSeconds());
        log.debug("getInstanceInfoReplicationIntervalSeconds()={}", (Object)seconds);
        return seconds;
    }
}

