/*
 * Decompiled with CFR 0.152.
 */
package am.ik.blog.entry.jdbc;

import am.ik.blog.entry.Author;
import am.ik.blog.entry.Categories;
import am.ik.blog.entry.Entry;
import am.ik.blog.entry.EntryId;
import am.ik.blog.entry.EntryMapper;
import am.ik.blog.entry.FrontMatter;
import am.ik.blog.entry.Tag;
import am.ik.blog.entry.Tags;
import am.ik.blog.entry.criteria.SearchCriteria;
import am.ik.blog.entry.jdbc.EntryExtractors;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.cloud.sleuth.annotation.NewSpan;
import org.springframework.cloud.sleuth.annotation.SpanTag;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Flux;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@Repository
public class EntryJdbcMapper
implements EntryMapper {
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public EntryJdbcMapper(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    @NewSpan
    public long count(SearchCriteria searchCriteria) {
        SearchCriteria.ClauseAndParams clauseAndParams = searchCriteria.toWhereClause();
        MapSqlParameterSource source = new MapSqlParameterSource();
        source.addValues(clauseAndParams.params());
        Long count = (Long)this.jdbcTemplate.queryForObject("SELECT count(e.entry_id) FROM entry AS e " + searchCriteria.toJoinClause() + " WHERE 1=1 " + clauseAndParams.clauseForEntryId(), (SqlParameterSource)source, Long.class);
        return count;
    }

    @Override
    @NewSpan
    public Entry findOne(@SpanTag(value="entryId") EntryId entryId, @SpanTag(value="excludeContent") boolean excludeContent) {
        MapSqlParameterSource source = new MapSqlParameterSource().addValue("entry_id", (Object)entryId.getValue());
        return ((Optional)this.jdbcTemplate.query("SELECT e.entry_id, e.title" + (excludeContent ? "" : ", e.content") + ", e.created_by, e.created_date, e.last_modified_by, e.last_modified_date, c.category_name FROM entry AS e LEFT OUTER JOIN category AS c ON e.entry_id = c.entry_id WHERE e.entry_id = :entry_id ORDER BY c.category_order ASC", (SqlParameterSource)source, EntryExtractors.forEntry(excludeContent))).map(e -> {
            List tags = this.jdbcTemplate.query("SELECT tag_name FROM entry_tag WHERE entry_id = :entry_id", (SqlParameterSource)source, (rs, i) -> new Tag(rs.getString("tag_name")));
            FrontMatter fm = e.getFrontMatter();
            return e.copy().frontMatter(new FrontMatter(fm.title(), fm.categories(), new Tags(tags), fm.date(), fm.updated())).build();
        }).orElse(null);
    }

    Map<EntryId, Tags> tagsMap(List<Long> ids) {
        MapSqlParameterSource source = new MapSqlParameterSource().addValue("entry_ids", ids);
        return this.jdbcTemplate.query("SELECT entry_id, tag_name FROM entry_tag WHERE entry_id IN (:entry_ids)", (SqlParameterSource)source, (rs, i) -> Tuples.of((Object)new EntryId(Long.valueOf(rs.getLong("entry_id"))), (Object)new Tag(rs.getString("tag_name")))).stream().collect(Collectors.groupingBy(Tuple2::getT1)).entrySet().stream().map(e -> Tuples.of(e.getKey(), (Object)new Tags(((List)e.getValue()).stream().map(Tuple2::getT2).collect(Collectors.toList())))).collect(Collectors.toMap(Tuple2::getT1, Tuple2::getT2));
    }

    List<Long> entryIds(SearchCriteria searchCriteria, Pageable pageable, SearchCriteria.ClauseAndParams clauseAndParams, MapSqlParameterSource source) {
        return this.jdbcTemplate.query("SELECT e.entry_id FROM entry AS e " + searchCriteria.toJoinClause() + " WHERE 1=1 " + clauseAndParams.clauseForEntryId() + " ORDER BY e.last_modified_date DESC LIMIT " + pageable.getPageSize() + " OFFSET " + pageable.getOffset(), (SqlParameterSource)source, (rs, i) -> rs.getLong("entry_id"));
    }

    String sqlForEntries(boolean excludeContent) {
        return "SELECT e.entry_id, e.title" + (excludeContent ? "" : ", e.content") + ", e.created_by, e.created_date, e.last_modified_by, e.last_modified_date, c.category_name FROM entry AS e LEFT JOIN category AS c ON e.entry_id = c.entry_id  WHERE e.entry_id IN (:entry_ids) ORDER BY e.last_modified_date DESC, c.category_order ASC";
    }

    @Override
    @NewSpan
    public List<Entry> findAll(SearchCriteria searchCriteria, Pageable pageable) {
        SearchCriteria.ClauseAndParams clauseAndParams = searchCriteria.toWhereClause();
        MapSqlParameterSource source = new MapSqlParameterSource();
        source.addValues(clauseAndParams.params());
        List<Long> ids = this.entryIds(searchCriteria, pageable, clauseAndParams, source);
        source.addValue("entry_ids", ids);
        boolean excludeContent = searchCriteria.isExcludeContent();
        Map<EntryId, Tags> tagsMap = this.tagsMap(ids);
        List entries = (List)this.jdbcTemplate.query(this.sqlForEntries(excludeContent), (SqlParameterSource)source, EntryExtractors.forEntries(excludeContent));
        return entries.stream().map(e -> {
            FrontMatter fm = e.getFrontMatter();
            EntryId entryId = e.getEntryId();
            Categories categories = fm.categories();
            Tags tags = (Tags)tagsMap.get(entryId);
            return e.copy().frontMatter(new FrontMatter(fm.title(), categories, tags, fm.date(), fm.updated())).build();
        }).collect(Collectors.toList());
    }

    @Override
    @NewSpan
    public Flux<Entry> collectAll(SearchCriteria searchCriteria, Pageable pageable) {
        SearchCriteria.ClauseAndParams clauseAndParams = searchCriteria.toWhereClause();
        MapSqlParameterSource source = new MapSqlParameterSource();
        source.addValues(clauseAndParams.params());
        List<Long> ids = this.entryIds(searchCriteria, pageable, clauseAndParams, source);
        source.addValue("entry_ids", ids);
        boolean excludeContent = searchCriteria.isExcludeContent();
        Map<EntryId, Tags> tagsMap = this.tagsMap(ids);
        return Flux.create(sink -> {
            this.jdbcTemplate.query(this.sqlForEntries(excludeContent), (SqlParameterSource)source, rs -> EntryExtractors.withEntries(rs, e -> {
                FrontMatter fm = e.getFrontMatter();
                EntryId entryId = e.getEntryId();
                Categories categories = fm.categories();
                Tags tags = (Tags)tagsMap.get(entryId);
                Entry entry = e.copy().frontMatter(new FrontMatter(fm.title(), categories, tags, fm.date(), fm.updated())).build();
                sink.next((Object)entry);
            }, excludeContent));
            sink.complete();
        });
    }

    @Override
    @NewSpan
    @Transactional
    public void save(Entry entry) {
        FrontMatter frontMatter = entry.frontMatter();
        Author created = entry.getCreated();
        Author updated = entry.getUpdated();
        MapSqlParameterSource source = new MapSqlParameterSource().addValue("entry_id", (Object)entry.entryId().getValue()).addValue("title", (Object)frontMatter.title().getValue()).addValue("content", (Object)entry.content().getValue()).addValue("created_by", (Object)created.getName().getValue()).addValue("created_date", (Object)created.getDate().getValue()).addValue("last_modified_by", (Object)updated.getName().getValue()).addValue("last_modified_date", (Object)updated.getDate().getValue());
        this.jdbcTemplate.update("INSERT INTO entry (entry_id, title, content, created_by, created_date, last_modified_by, last_modified_date) VALUES (:entry_id, :title, :content, :created_by, :created_date, :last_modified_by, :last_modified_date) ON DUPLICATE KEY UPDATE title = :title, content = :content, created_by = :created_by, created_date = :created_date, last_modified_by = :last_modified_by, last_modified_date = :last_modified_date", (SqlParameterSource)source);
        AtomicInteger order = new AtomicInteger(0);
        SqlParameterSource[] categories = (SqlParameterSource[])frontMatter.getCategories().getValue().stream().map(category -> new MapSqlParameterSource().addValue("category_name", (Object)category.getValue()).addValue("category_order", (Object)order.getAndIncrement()).addValue("entry_id", (Object)entry.entryId().getValue())).toArray(SqlParameterSource[]::new);
        this.jdbcTemplate.update("DELETE FROM category WHERE entry_id = :entry_id", (SqlParameterSource)source);
        this.jdbcTemplate.batchUpdate("INSERT INTO category (category_name, category_order, entry_id) VALUES (:category_name, :category_order, :entry_id)", categories);
        SqlParameterSource[] tags = (SqlParameterSource[])frontMatter.getTags().getValue().stream().map(tag -> new MapSqlParameterSource().addValue("tag", (Object)tag.getValue()).addValue("entry_id", (Object)entry.entryId().getValue())).toArray(SqlParameterSource[]::new);
        this.jdbcTemplate.update("DELETE FROM entry_tag WHERE entry_id = :entry_id", (SqlParameterSource)source);
        this.jdbcTemplate.batchUpdate("INSERT INTO tag (tag_name) VALUES (:tag) ON DUPLICATE KEY UPDATE tag_name = :tag", tags);
        this.jdbcTemplate.batchUpdate("INSERT INTO entry_tag (entry_id, tag_name) VALUES (:entry_id, :tag)", tags);
    }

    @Override
    @NewSpan
    @Transactional
    public int delete(@SpanTag(value="entryId") EntryId entryId) {
        MapSqlParameterSource source = new MapSqlParameterSource().addValue("entry_id", (Object)entryId.getValue());
        return this.jdbcTemplate.update("DELETE FROM entry WHERE entry_id = :entry_id", (SqlParameterSource)source);
    }
}

