/*
 * Decompiled with CFR 0.152.
 */
package am.ik.blog.entry.jdbc;

import am.ik.blog.entry.Author;
import am.ik.blog.entry.Categories;
import am.ik.blog.entry.Category;
import am.ik.blog.entry.Content;
import am.ik.blog.entry.Entry;
import am.ik.blog.entry.EntryId;
import am.ik.blog.entry.EventTime;
import am.ik.blog.entry.FrontMatter;
import am.ik.blog.entry.Name;
import am.ik.blog.entry.Tag;
import am.ik.blog.entry.Tags;
import am.ik.blog.entry.Title;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.util.StringUtils;

class EntryExtractors {
    static final ZoneOffset zoneOffset = OffsetDateTime.now().getOffset();

    EntryExtractors() {
    }

    static ResultSetExtractor<Optional<Entry>> forEntry(boolean excludeContent) {
        return rs -> {
            if (!rs.next()) {
                return Optional.empty();
            }
            ArrayList<Category> categories = new ArrayList<Category>();
            Entry.EntryBuilder builder = EntryExtractors.builder(rs, categories, excludeContent);
            do {
                String categoryName;
                if (StringUtils.isEmpty((Object)(categoryName = rs.getString("category_name")))) continue;
                categories.add(new Category(categoryName));
            } while (rs.next());
            return Optional.of(builder.build());
        };
    }

    static ResultSetExtractor<List<Entry>> forEntries(boolean excludeContent) {
        return rs -> {
            ArrayList entries = new ArrayList();
            if (rs.next()) {
                EntryExtractors.withEntries(rs, entries::add, excludeContent);
            }
            return entries;
        };
    }

    static void withEntries(ResultSet rs, Consumer<Entry> consumer, boolean excludeContent) throws SQLException {
        long prevId = -1L;
        Entry.EntryBuilder builder = null;
        ArrayList<Category> categories = new ArrayList<Category>();
        do {
            long entryId;
            if ((entryId = rs.getLong("entry_id")) != prevId) {
                if (builder != null) {
                    Entry entry = builder.build();
                    consumer.accept(entry);
                }
                categories = new ArrayList();
                builder = EntryExtractors.builder(rs, categories, excludeContent);
            }
            Category category = new Category(rs.getString("category_name"));
            categories.add(category);
            prevId = entryId;
        } while (rs.next());
        if (builder != null) {
            Entry entry = builder.build();
            consumer.accept(entry);
        }
    }

    private static Entry.EntryBuilder builder(ResultSet rs, List<Category> categories, boolean excludeContent) throws SQLException {
        EventTime createdDate = new EventTime(OffsetDateTime.of(rs.getTimestamp("created_date").toLocalDateTime(), zoneOffset));
        EventTime lastModifiedDate = new EventTime(OffsetDateTime.of(rs.getTimestamp("last_modified_date").toLocalDateTime(), zoneOffset));
        Entry.EntryBuilder entryBuilder = Entry.builder().entryId(new EntryId(Long.valueOf(rs.getLong("entry_id"))));
        entryBuilder = !excludeContent ? entryBuilder.content(new Content(rs.getString("content"))) : entryBuilder.content(new Content(""));
        return entryBuilder.frontMatter(new FrontMatter(new Title(rs.getString("title")), new Categories(categories), new Tags(new Tag[0]), createdDate, lastModifiedDate)).created(new Author(new Name(rs.getString("created_by")), createdDate)).updated(new Author(new Name(rs.getString("last_modified_by")), lastModifiedDate));
    }
}

