/*
 * Decompiled with CFR 0.152.
 */
package am.ik.blog.entry.criteria;

import am.ik.blog.entry.Name;
import am.ik.blog.entry.Tag;
import am.ik.blog.entry.criteria.CategoryOrders;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class SearchCriteria {
    public static final SearchCriteria DEFAULT = SearchCriteria.defaults().build();
    private boolean excludeContent;
    private Name createdBy;
    private Name lastModifiedBy;
    private Tag tag;
    private CategoryOrders categoryOrders;
    private String keyword;

    public static SearchCriteriaBuilder defaults() {
        return SearchCriteria.builder().excludeContent(true);
    }

    public String toJoinClause() {
        StringBuilder sb = new StringBuilder();
        if (this.tag != null) {
            sb.append("LEFT JOIN entry_tag AS et ON e.entry_id = et.entry_id ");
        }
        if (this.categoryOrders != null) {
            sb.append("LEFT JOIN category AS c ON e.entry_id = c.entry_id ");
        }
        return sb.toString();
    }

    public ClauseAndParams toWhereClause() {
        LinkedHashMap<String, String> clause = new LinkedHashMap<String, String>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((Object)this.keyword)) {
            params.put("keyword", "%" + this.keyword + "%");
            clause.put("keyword", "AND e.content LIKE :keyword");
        }
        if (this.createdBy != null) {
            params.put("created_by", this.createdBy.getValue());
            clause.put("created_by", "AND e.created_by = :created_by");
        }
        if (this.lastModifiedBy != null) {
            params.put("last_modified_by", this.lastModifiedBy.getValue());
            clause.put("last_modified_by", "AND e.last_modified_by = :last_modified_by");
        }
        if (this.categoryOrders != null) {
            this.categoryOrders.getValue().forEach(c -> {
                int categoryOrder = c.getCategoryOrder();
                String categoryNameKey = "category_name" + categoryOrder;
                String categoryOrderKey = "category_order" + categoryOrder;
                params.put(categoryNameKey, c.getCategory().getValue());
                clause.put(categoryNameKey, "AND c.category_name = :" + categoryNameKey);
                params.put(categoryOrderKey, categoryOrder);
                clause.put(categoryOrderKey, "AND c.category_order = :" + categoryOrderKey);
            });
        }
        if (this.tag != null) {
            params.put("tag", this.tag.getValue());
            clause.put("tag", "AND et.tag_name = :tag");
        }
        return new ClauseAndParams(clause, params);
    }

    SearchCriteria(boolean excludeContent, Name createdBy, Name lastModifiedBy, Tag tag, CategoryOrders categoryOrders, String keyword) {
        this.excludeContent = excludeContent;
        this.createdBy = createdBy;
        this.lastModifiedBy = lastModifiedBy;
        this.tag = tag;
        this.categoryOrders = categoryOrders;
        this.keyword = keyword;
    }

    public static SearchCriteriaBuilder builder() {
        return new SearchCriteriaBuilder();
    }

    public boolean isExcludeContent() {
        return this.excludeContent;
    }

    public Name getCreatedBy() {
        return this.createdBy;
    }

    public Name getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public Tag getTag() {
        return this.tag;
    }

    public CategoryOrders getCategoryOrders() {
        return this.categoryOrders;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public static class SearchCriteriaBuilder {
        private boolean excludeContent;
        private Name createdBy;
        private Name lastModifiedBy;
        private Tag tag;
        private CategoryOrders categoryOrders;
        private String keyword;

        SearchCriteriaBuilder() {
        }

        public SearchCriteriaBuilder excludeContent(boolean excludeContent) {
            this.excludeContent = excludeContent;
            return this;
        }

        public SearchCriteriaBuilder createdBy(Name createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public SearchCriteriaBuilder lastModifiedBy(Name lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public SearchCriteriaBuilder tag(Tag tag) {
            this.tag = tag;
            return this;
        }

        public SearchCriteriaBuilder categoryOrders(CategoryOrders categoryOrders) {
            this.categoryOrders = categoryOrders;
            return this;
        }

        public SearchCriteriaBuilder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public SearchCriteria build() {
            return new SearchCriteria(this.excludeContent, this.createdBy, this.lastModifiedBy, this.tag, this.categoryOrders, this.keyword);
        }

        public String toString() {
            return "SearchCriteria.SearchCriteriaBuilder(excludeContent=" + this.excludeContent + ", createdBy=" + this.createdBy + ", lastModifiedBy=" + this.lastModifiedBy + ", tag=" + this.tag + ", categoryOrders=" + this.categoryOrders + ", keyword=" + this.keyword + ")";
        }
    }

    public static class ClauseAndParams {
        private final Map<String, String> clause;
        private final Map<String, Object> params;

        ClauseAndParams(Map<String, String> clause, Map<String, Object> params) {
            this.clause = clause;
            this.params = params;
        }

        public String clauseForEntryId() {
            return this.clause.values().stream().collect(Collectors.joining(" "));
        }

        public Map<String, Object> params() {
            return this.params;
        }
    }
}

