/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server;

import java.lang.reflect.Method;
import java.util.Vector;
import org.apache.altrmi.common.MethodNameHelper;
import org.apache.altrmi.server.AttributeHelper;
import org.apache.altrmi.server.PublicationException;

public class PublicationDescriptionItem {
    private final Class m_facadeClass;
    private final Vector m_asyncMethods;
    private final Vector m_commitMethods;
    private final Vector m_rollbackMethods;

    public PublicationDescriptionItem(Class facadeClass) {
        block6: {
            this.m_asyncMethods = new Vector();
            this.m_commitMethods = new Vector();
            this.m_rollbackMethods = new Vector();
            this.m_facadeClass = facadeClass;
            Method[] methods = facadeClass.getDeclaredMethods();
            try {
                AttributeHelper attributeHelper = new AttributeHelper();
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    if (attributeHelper.isMethodAsync(method)) {
                        this.m_asyncMethods.add(MethodNameHelper.getMethodSignature((Method)method));
                    }
                    if (attributeHelper.isMethodAsyncCommit(method)) {
                        this.m_commitMethods.add(MethodNameHelper.getMethodSignature((Method)method));
                    }
                    if (!attributeHelper.isMethodAsyncRollback(method)) continue;
                    this.m_rollbackMethods.add(MethodNameHelper.getMethodSignature((Method)method));
                }
            }
            catch (NoClassDefFoundError ncdfe) {
            }
            catch (RuntimeException re) {
                if (re.getClass().getName().equals("org.apache.commons.attributes.AttributesException")) break block6;
                throw re;
            }
        }
    }

    public PublicationDescriptionItem(Class facadeClass, String[] asyncMethods, String[] commitMethods, String[] rollbackMethods) throws PublicationException {
        int i;
        this.m_asyncMethods = new Vector();
        this.m_commitMethods = new Vector();
        this.m_rollbackMethods = new Vector();
        this.m_facadeClass = facadeClass;
        if (facadeClass == null) {
            throw new RuntimeException("Facade class nust not be null");
        }
        for (i = 0; i < asyncMethods.length; ++i) {
            String asyncMethod = asyncMethods[i];
            this.testAsyncMethodType(facadeClass.getMethods(), asyncMethod);
            this.m_asyncMethods.add(asyncMethod);
        }
        for (i = 0; i < commitMethods.length; ++i) {
            String commitMethod = commitMethods[i];
            this.testAsyncMethodType(facadeClass.getMethods(), commitMethod);
            this.m_commitMethods.add(commitMethod);
        }
        for (i = 0; i < rollbackMethods.length; ++i) {
            String rollbackMethod = rollbackMethods[i];
            this.testAsyncMethodType(facadeClass.getMethods(), rollbackMethod);
            this.m_rollbackMethods.add(rollbackMethod);
        }
    }

    private void testAsyncMethodType(Method[] methods, String methodSignature) throws PublicationException {
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!MethodNameHelper.getMethodSignature((Method)method).equals(methodSignature)) continue;
            if (!method.getReturnType().toString().equals("void")) {
                throw new PublicationException("Only 'void' returning methods are eligible for asynchronous methods.");
            }
            Class<?>[] exceptions = method.getExceptionTypes();
            if (exceptions.length == 0) continue;
            throw new PublicationException("Only methods without exceptions are eligible for asynchronous behavior ");
        }
    }

    public Class getFacadeClass() {
        return this.m_facadeClass;
    }

    public boolean isCommit(Method method) {
        String mthSig = MethodNameHelper.getMethodSignature((Method)method);
        for (int i = 0; i < this.m_commitMethods.size(); ++i) {
            String asyncMethod = (String)this.m_commitMethods.elementAt(i);
            if (!asyncMethod.equals(mthSig)) continue;
            return true;
        }
        return false;
    }

    public boolean isRollback(Method method) {
        String mthSig = MethodNameHelper.getMethodSignature((Method)method);
        for (int i = 0; i < this.m_rollbackMethods.size(); ++i) {
            String asyncMethod = (String)this.m_rollbackMethods.elementAt(i);
            if (!asyncMethod.equals(mthSig)) continue;
            return true;
        }
        return false;
    }

    public boolean isAsync(Method method) {
        String mthSig = MethodNameHelper.getMethodSignature((Method)method);
        for (int i = 0; i < this.m_asyncMethods.size(); ++i) {
            String asyncMethod = (String)this.m_asyncMethods.elementAt(i);
            if (!asyncMethod.equals(mthSig)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAsyncBehavior() {
        return this.m_asyncMethods.size() != 0 | this.m_commitMethods.size() != 0 | this.m_rollbackMethods.size() != 0;
    }
}

