/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.javacompiler;

import java.io.ByteArrayOutputStream;
import org.apache.altrmi.javacompiler.SunJavaCompiler;

public abstract class JavaCompiler {
    static String CPSEP = System.getProperty("path.separator");
    protected String m_classpath;
    protected String m_compilerPath = "jikes";
    protected String m_outdir;
    protected ByteArrayOutputStream m_out;
    protected boolean m_classDebugInfo = false;

    protected JavaCompiler() {
        this.reset();
    }

    public void setCompilerPath(String m_compilerPath) {
        if (m_compilerPath != null) {
            this.m_compilerPath = m_compilerPath;
        }
    }

    public void addClassPath(String path) {
        this.m_classpath = this.m_classpath + CPSEP + path;
    }

    public void addDefaultClassPath() {
        this.addClassPath(System.getProperty("java.class.path"));
    }

    public void setOutputDir(String outdir) {
        this.m_outdir = outdir;
    }

    public String getCompilerMessage() {
        return this.m_out.toString();
    }

    public void reset() {
        this.m_out = new ByteArrayOutputStream(256);
    }

    public abstract boolean doCompile(String var1);

    public static JavaCompiler getDefaultCompiler() {
        return new SunJavaCompiler();
    }
}

