/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.generator.ant;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.altrmi.common.ProxyGenerationException;
import org.apache.altrmi.common.ProxyGenerator;
import org.apache.altrmi.server.PublicationDescriptionItem;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class ProxyGenerationTask
extends Task {
    protected String[] m_interfacesToExpose;
    protected String[] m_additionalFacades;
    protected String[] m_callbackFacades;
    protected File m_srcGenDir;
    protected File m_classGenDir;
    protected String m_genName;
    protected Path m_classpath;
    protected String m_verbose = "false";
    private String m_generatorClass = "org.apache.altrmi.generator.ProxyGeneratorImpl";

    public void setInterfaces(String interfacesToExpose) {
        StringTokenizer st = new StringTokenizer(interfacesToExpose, ",");
        Vector<String> strings = new Vector<String>();
        while (st.hasMoreTokens()) {
            strings.add(st.nextToken().trim());
        }
        this.m_interfacesToExpose = new String[strings.size()];
        strings.copyInto(this.m_interfacesToExpose);
    }

    public void setAdditionalfacades(String additionalfacades) {
        StringTokenizer st = new StringTokenizer(additionalfacades, ",");
        Vector<String> strings = new Vector<String>();
        while (st.hasMoreTokens()) {
            strings.add(st.nextToken().trim());
        }
        this.m_additionalFacades = new String[strings.size()];
        strings.copyInto(this.m_additionalFacades);
    }

    public void setCallbackfacades(String callbackfacades) {
        StringTokenizer st = new StringTokenizer(callbackfacades, ",");
        Vector<String> strings = new Vector<String>();
        while (st.hasMoreTokens()) {
            strings.add(st.nextToken().trim());
        }
        this.m_callbackFacades = new String[strings.size()];
        strings.copyInto(this.m_callbackFacades);
    }

    public void setSrcgendir(File srcGenDir) {
        this.m_srcGenDir = srcGenDir;
    }

    public void setClassgendir(File classGenDir) {
        this.m_classGenDir = classGenDir;
    }

    public void setGenname(String genName) {
        this.m_genName = genName;
    }

    public void setClasspath(Path classpath) {
        if (this.m_classpath == null) {
            this.m_classpath = classpath;
        } else {
            this.m_classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.m_classpath == null) {
            this.m_classpath = new Path(this.project);
        }
        return this.m_classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setVerbose(String verbose) {
        this.m_verbose = verbose;
    }

    public void setGeneratorClass(String generatorClass) {
        this.m_generatorClass = generatorClass;
    }

    public void execute() throws BuildException {
        ProxyGenerator proxyGenerator;
        if (this.m_interfacesToExpose == null) {
            throw new BuildException("Specify at least one interface to expose");
        }
        if (this.m_srcGenDir == null) {
            throw new BuildException("Specify the directory to generate Java source in");
        }
        if (this.m_classGenDir == null) {
            throw new BuildException("Specify the directory to generate Java classes in");
        }
        if (this.m_genName == null) {
            throw new BuildException("Specify the name to use for lookup");
        }
        try {
            proxyGenerator = (ProxyGenerator)Class.forName(this.m_generatorClass).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("PrimaryGenerator Impl jar not in m_classpath");
        }
        try {
            String cn;
            proxyGenerator.setSrcGenDir(this.m_srcGenDir.getAbsolutePath());
            proxyGenerator.setClassGenDir(this.m_classGenDir.getAbsolutePath());
            proxyGenerator.setGenName(this.m_genName);
            proxyGenerator.verbose(Boolean.valueOf(this.m_verbose).booleanValue());
            proxyGenerator.setClasspath(this.m_classpath.concatSystemClasspath("ignore").toString());
            PublicationDescriptionItem[] interfacesToExpose = new PublicationDescriptionItem[this.m_interfacesToExpose.length];
            AntClassLoader classLoader = new AntClassLoader(this.getProject(), this.m_classpath);
            for (int i = 0; i < this.m_interfacesToExpose.length; ++i) {
                String cn2 = this.m_interfacesToExpose[i];
                interfacesToExpose[i] = new PublicationDescriptionItem(classLoader.loadClass(cn2));
            }
            proxyGenerator.setInterfacesToExpose(interfacesToExpose);
            if (this.m_additionalFacades != null) {
                PublicationDescriptionItem[] additionalFacades = new PublicationDescriptionItem[this.m_additionalFacades.length];
                for (int i = 0; i < this.m_additionalFacades.length; ++i) {
                    cn = this.m_additionalFacades[i];
                    additionalFacades[i] = new PublicationDescriptionItem(classLoader.loadClass(cn));
                }
                proxyGenerator.setAdditionalFacades(additionalFacades);
            }
            if (this.m_callbackFacades != null) {
                PublicationDescriptionItem[] callbackFacades = new PublicationDescriptionItem[this.m_callbackFacades.length];
                for (int i = 0; i < this.m_callbackFacades.length; ++i) {
                    cn = this.m_callbackFacades[i];
                    callbackFacades[i] = new PublicationDescriptionItem(classLoader.loadClass(cn));
                }
                proxyGenerator.setCallbackFacades(callbackFacades);
            }
            ClassLoader classLoader2 = null;
            classLoader2 = this.m_classpath != null ? new AntClassLoader(this.project, this.m_classpath) : ((Object)((Object)this)).getClass().getClassLoader();
            proxyGenerator.generateSrc(classLoader2);
            proxyGenerator.generateClass(classLoader2);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            throw new BuildException("Class not found : " + cnfe.getMessage());
        }
        catch (ProxyGenerationException sge) {
            throw new BuildException("Proxy Gerneation error : " + sge.getMessage());
        }
    }
}

