/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.generator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Vector;
import org.apache.altrmi.common.MethodNameHelper;
import org.apache.altrmi.common.ProxyGenerationException;
import org.apache.altrmi.generator.AbstractProxyGenerator;
import org.apache.altrmi.javacompiler.JavaCompiler;
import org.apache.altrmi.server.PublicationDescriptionItem;

public class ProxyGeneratorImpl
extends AbstractProxyGenerator {
    public void generateSrc(ClassLoader classLoader) throws ProxyGenerationException {
        this.makeSource(classLoader, "Main", this.getInterfacesToExpose());
        if (this.getAdditionalFacades() != null) {
            for (int i = 0; i < this.getAdditionalFacades().length; ++i) {
                PublicationDescriptionItem facade = this.getAdditionalFacades()[i];
                this.makeSource(classLoader, MethodNameHelper.encodeClassName((Class)facade.getFacadeClass()), new PublicationDescriptionItem[]{facade});
            }
        }
    }

    public void generateClass(ClassLoader classLoader) {
        JavaCompiler jc = JavaCompiler.getDefaultCompiler();
        jc.setOutputDir(this.getClassGenDir());
        jc.addClassPath(this.getClassGenDir());
        jc.addClassPath(this.getClasspath());
        jc.addDefaultClassPath();
        jc.doCompile(this.getSrcGenDir() + File.separator + "AltrmiGenerated" + this.getGenName() + "_Main.java");
        System.out.println(jc.getCompilerMessage());
        if (this.getAdditionalFacades() != null) {
            for (int i = 0; i < this.getAdditionalFacades().length; ++i) {
                String classname = MethodNameHelper.encodeClassName((Class)this.getAdditionalFacades()[i].getFacadeClass());
                jc.doCompile(this.getSrcGenDir() + File.separator + "AltrmiGenerated" + this.getGenName() + "_" + classname + ".java");
            }
        }
    }

    public void generateDeferredClasses() {
        JavaCompiler jc = JavaCompiler.getDefaultCompiler();
        jc.setOutputDir(this.getClassGenDir());
        jc.setCompilerPath(this.getSrcGenDir());
        jc.addClassPath(this.getClassGenDir());
        jc.addClassPath(this.getClasspath());
        jc.addDefaultClassPath();
        jc.doCompile("*.java");
        System.out.println(jc.getCompilerMessage());
    }

    public void makeSource(ClassLoader classloader, String name, PublicationDescriptionItem[] interfacesToExpose) throws ProxyGenerationException {
        Vector methodsDone = new Vector();
        String filename = this.getSrcGenDir() + File.separator + "AltrmiGenerated" + this.getGenName() + "_" + name + ".java";
        PrintWriter classSource = null;
        try {
            classSource = new PrintWriter(new FileOutputStream(filename));
        }
        catch (FileNotFoundException e) {
            throw new ProxyGenerationException("Cannot make source output file '" + filename + "'");
        }
        classSource.print("public final class AltrmiGenerated" + this.getGenName() + "_" + name);
        classSource.println(" implements org.apache.altrmi.client.Proxy, ");
        this.generateInterfaceList(classSource, interfacesToExpose);
        classSource.println(" { ");
        classSource.println("  private transient org.apache.altrmi.client.ProxyHelper m_proxyHelper;");
        classSource.println("  public AltrmiGenerated" + this.getGenName() + "_" + name + " (org.apache.altrmi.client.ProxyHelper proxyHelper) {");
        classSource.println("      m_proxyHelper = proxyHelper;");
        classSource.println("  }");
        classSource.println("    public Long altrmiGetReferenceID(Object factoryThatIsAsking) {");
        classSource.println("        return m_proxyHelper.getReferenceID(factoryThatIsAsking);");
        classSource.println("    }");
        this.makeSourceInterfaces(classSource, interfacesToExpose, methodsDone);
        classSource.print("}");
        classSource.close();
    }

    private void makeSourceInterfaces(PrintWriter classSource, PublicationDescriptionItem[] interfacesToExpose, Vector methodsDone) throws ProxyGenerationException {
        this.generateEqualsMethod(classSource);
        methodsDone.add("equals(java.lang.Object)");
        for (int x = 0; x < interfacesToExpose.length; ++x) {
            PublicationDescriptionItem interfaceToExpose = interfacesToExpose[x];
            Class clazz = interfaceToExpose.getFacadeClass();
            if (this.isVerbose()) {
                System.out.println("ProxyGen: Processing interface: " + clazz.getName());
            }
            Method[] methods = this.getGeneratableMethods(clazz);
            for (int y = 0; y < methods.length; ++y) {
                Method method = methods[y];
                String methodSignature = MethodNameHelper.getMethodSignature((Method)method);
                if (this.isVerbose()) {
                    System.out.println("ProxyGen:   Processing method: " + methodSignature);
                }
                if (methodsDone.contains(methodSignature)) continue;
                this.makeSourceInterfacesMethodsNotDone(classSource, methodsDone, methodSignature, method, interfaceToExpose.isAsync(method), interfaceToExpose.isCommit(method), interfaceToExpose.isRollback(method));
            }
        }
    }

    private void generateEqualsMethod(PrintWriter classSource) {
        classSource.println("  public boolean equals(Object o) {");
        classSource.println("    return m_proxyHelper.isEquals(this,o);");
        classSource.println("  }");
    }

    private void makeSourceInterfacesMethodsNotDone(PrintWriter classSource, Vector methodsDone, String methodSignature, Method method, boolean async, boolean commit, boolean rollback) throws ProxyGenerationException {
        methodsDone.add(methodSignature);
        Class<?> rClass = method.getReturnType();
        if (!(method.getReturnType() instanceof Serializable)) {
            throw new ProxyGenerationException("Return type " + rClass + " must be serializable");
        }
        String mName = method.getName();
        classSource.print("  public " + this.generateReturnValue(rClass) + " " + mName + " (");
        Class[] argTypes = method.getParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            String cn;
            String string = cn = argTypes[i].isArray() ? argTypes[i].getComponentType().getName() : argTypes[i].getName();
            if (!(argTypes[i] instanceof Serializable)) {
                throw new ProxyGenerationException("Argument type " + cn + " must be serializable");
            }
            this.generateParameter(classSource, argTypes[i], i);
        }
        classSource.print(") ");
        Class[] throwsTypes = method.getExceptionTypes();
        for (int i = 0; i < throwsTypes.length; ++i) {
            this.generateThrows(classSource, i, throwsTypes);
        }
        classSource.println("{");
        if (async) {
            this.generateAsyncMethodBody(classSource, argTypes, rClass, methodSignature, method);
        } else if (commit) {
            this.generateAsyncMethodBody(classSource, argTypes, rClass, methodSignature, method);
            this.generateAsyncCommitMethodBody(classSource);
        } else if (rollback) {
            this.generateAsyncRollbackMethodBody(classSource);
            this.generateNonAsyncMethodBody(classSource, argTypes, rClass, methodSignature, method);
        } else {
            this.generateNonAsyncMethodBody(classSource, argTypes, rClass, methodSignature, method);
        }
        classSource.println("  }");
    }

    private void generateNonAsyncMethodBody(PrintWriter classSource, Class[] argTypes, Class rClass, String methodSignature, Method method) {
        this.generateMethodBody(classSource, argTypes, rClass, methodSignature, method, "processVoidRequest");
    }

    private void generateAsyncMethodBody(PrintWriter classSource, Class[] argTypes, Class rClass, String methodSignature, Method method) {
        this.generateMethodBody(classSource, argTypes, rClass, methodSignature, method, "queueAsyncRequest");
    }

    private void generateMethodBody(PrintWriter classSource, Class[] argTypes, Class rClass, String methodSignature, Method method, String proxyMethodName) {
        this.generateMethodArgs(classSource, argTypes);
        classSource.println("    try {");
        if (rClass.toString().equals("void")) {
            classSource.println("      m_proxyHelper." + proxyMethodName + "(\"" + methodSignature + "\",args,argClasses);");
        } else {
            this.makeSourceInterfacesMethodsNotDoneNotVoid(classSource, method, rClass, methodSignature);
        }
        classSource.println("    } catch (Throwable t) {");
        Class[] throwsTypes = method.getExceptionTypes();
        for (int i = 0; i < throwsTypes.length; ++i) {
            this.generateThrowHandler(classSource, i, throwsTypes);
        }
        classSource.println("      if (t instanceof RuntimeException) { ");
        classSource.println("        throw (RuntimeException) t;");
        classSource.println("      } else if (t instanceof Error) { ");
        classSource.println("        throw (Error) t;");
        classSource.println("      } else { ");
        classSource.println("        t.printStackTrace(); ");
        classSource.println("        throw new org.apache.altrmi.client.InvocationException(\"Should never get here: \" +t.getMessage());");
        classSource.println("      }");
        classSource.println("    }");
    }

    private void generateMethodArgs(PrintWriter classSource, Class[] argTypes) {
        classSource.println("    Object[] args = new Object[" + argTypes.length + "];");
        classSource.println("    Class[] argClasses = new Class[" + argTypes.length + "];");
        for (int i = 0; i < argTypes.length; ++i) {
            this.generateAssignLine(classSource, argTypes[i], i);
        }
    }

    private void generateAsyncCommitMethodBody(PrintWriter classSource) {
        classSource.println("    try {");
        classSource.println("      m_proxyHelper.commitAsyncRequests();");
        classSource.println("    } catch (Throwable t) {");
        classSource.println("      if (t instanceof RuntimeException) { ");
        classSource.println("        throw (RuntimeException) t;");
        classSource.println("      } else if (t instanceof Error) { ");
        classSource.println("        throw (Error) t;");
        classSource.println("      } else { ");
        classSource.println("        t.printStackTrace(); ");
        classSource.println("        throw new org.apache.altrmi.client.InvocationException(\"Should never get here: \" +t.getMessage());");
        classSource.println("      }");
        classSource.println("    }");
    }

    private void generateAsyncRollbackMethodBody(PrintWriter classSource) {
        Vector v = new Vector();
        v.removeAllElements();
        classSource.println("    try {");
        classSource.println("      m_proxyHelper.rollbackAsyncRequests();");
        classSource.println("    } catch (Throwable t) {");
        classSource.println("      if (t instanceof RuntimeException) { ");
        classSource.println("        throw (RuntimeException) t;");
        classSource.println("      } else if (t instanceof Error) { ");
        classSource.println("        throw (Error) t;");
        classSource.println("      } else { ");
        classSource.println("        t.printStackTrace(); ");
        classSource.println("        throw new org.apache.altrmi.client.InvocationException(\"Should never get here: \" +t.getMessage());");
        classSource.println("      }");
        classSource.println("    }");
    }

    private void makeSourceInterfacesMethodsNotDoneNotVoid(PrintWriter classSource, Method method, Class rClass, String methodSignature) {
        boolean isFacadeRetVal = this.isAdditionalFacade(method.getReturnType());
        if (isFacadeRetVal) {
            Class<?> retClassType = rClass;
            if (rClass.isArray()) {
                retClassType = rClass.getComponentType();
            }
            classSource.println("  Object retVal = m_proxyHelper.processObjectRequestGettingFacade(" + retClassType.getName() + ".class , \"" + methodSignature + "\",args,\"" + MethodNameHelper.encodeClassName((String)this.getClassType(rClass)) + "\");");
            classSource.println("      return (" + this.getClassType(rClass) + ") retVal;");
        } else {
            classSource.println("      Object retVal = m_proxyHelper.processObjectRequest(\"" + methodSignature + "\",args,argClasses);");
            this.generateReturnLine(classSource, rClass);
        }
    }

    private void generateThrowHandler(PrintWriter classSource, int i, Class[] throwsTypes) {
        if (i == 0) {
            classSource.println("      if (t instanceof " + throwsTypes[i].getName() + ") { ");
        } else {
            classSource.println("      } else if (t instanceof " + throwsTypes[i].getName() + ") { ");
        }
        classSource.println("        throw (" + throwsTypes[i].getName() + ") t;");
        if (i + 1 == throwsTypes.length) {
            classSource.print("      } else");
        }
    }

    private void generateThrows(PrintWriter classSource, int i, Class[] throwsTypes) {
        if (i == 0) {
            classSource.print("throws ");
        }
        classSource.print(throwsTypes[i].getName());
        if (i + 1 < throwsTypes.length) {
            classSource.print(", ");
        }
    }

    private void generateInterfaceList(PrintWriter classSource, PublicationDescriptionItem[] interfacesToExpose) {
        for (int x = 0; x < interfacesToExpose.length; ++x) {
            classSource.print(interfacesToExpose[x].getFacadeClass().getName());
            if (x + 1 >= interfacesToExpose.length) continue;
            classSource.print(", ");
        }
    }

    private void generateParameter(PrintWriter classSource, Class cl, int i) {
        if (i > 0) {
            classSource.print(", ");
        }
        if (cl.isArray()) {
            classSource.print(cl.getComponentType().getName() + "[]");
        } else {
            classSource.print(cl.getName());
        }
        classSource.print(" v" + i);
    }

    private void generateAssignLine(PrintWriter classSource, Class clazz, int i) {
        String cn = clazz.getName();
        if (cn.equals("int")) {
            classSource.println("    args[" + i + "] = new Integer(v" + i + ");");
        } else if (cn.equals("short")) {
            classSource.println("    args[" + i + "] = new Short(v" + i + ");");
        } else if (cn.equals("float")) {
            classSource.println("    args[" + i + "] = new Float(v" + i + ");");
        } else if (cn.equals("double")) {
            classSource.println("    args[" + i + "] = new Double(v" + i + ");");
        } else if (cn.equals("long")) {
            classSource.println("    args[" + i + "] = new Long(v" + i + ");");
        } else if (cn.equals("char")) {
            classSource.println("    args[" + i + "] = new Character(v" + i + ");");
        } else if (cn.equals("boolean")) {
            classSource.println("    args[" + i + "] = new Boolean(v" + i + ");");
        } else if (cn.equals("byte")) {
            classSource.println("    args[" + i + "] = new Byte(v" + i + ");");
        } else {
            classSource.println("    args[" + i + "] = v" + i + ";");
            classSource.println("    argClasses[" + i + "] = " + this.generateReturnValue(clazz) + ".class;");
        }
    }

    private void generateReturnLine(PrintWriter classSource, Class rClass) {
        String cn = rClass.getName();
        if (cn.equals("boolean")) {
            classSource.println("      return ((Boolean) retVal).booleanValue();");
        } else if (cn.equals("int")) {
            classSource.println("      return ((Integer) retVal).intValue();");
        } else if (cn.equals("short")) {
            classSource.println("      return ((Short) retVal).shortValue();");
        } else if (cn.equals("float")) {
            classSource.println("      return ((Float) retVal).floatValue();");
        } else if (cn.equals("double")) {
            classSource.println("      return ((Double) retVal).doubleValue();");
        } else if (cn.equals("long")) {
            classSource.println("      return ((Long) retVal).longValue();");
        } else if (cn.equals("char")) {
            classSource.println("      return ((Character) retVal).charValue();");
        } else if (cn.equals("void")) {
            classSource.println("      return;");
        } else if (cn.equals("byte")) {
            classSource.println("      return ((Byte) retVal).byteValue();");
        } else if (cn.equals("[B")) {
            classSource.println("      return (byte[]) retVal;");
        } else if (cn.equals("[C")) {
            classSource.println("      return (char[]) retVal;");
        } else if (cn.equals("[D")) {
            classSource.println("      return (double[]) retVal;");
        } else if (cn.equals("[F")) {
            classSource.println("      return (float[]) retVal;");
        } else if (cn.equals("[I")) {
            classSource.println("      return (int[]) retVal;");
        } else if (cn.equals("[J")) {
            classSource.println("      return (long[]) retVal;");
        } else if (cn.equals("[S")) {
            classSource.println("      return (short[]) retVal;");
        } else if (cn.equals("[Z")) {
            classSource.println("      return (boolean[]) retVal;");
        } else if (rClass.getName().startsWith("[L")) {
            classSource.println("      return (" + cn.substring(2, cn.length() - 1) + "[]) retVal;");
        } else {
            classSource.println("      return (" + cn + ") retVal;");
        }
    }

    private String generateReturnValue(Class rClass) {
        String cn = rClass.getName();
        if (cn.equals("[B")) {
            return "byte[]";
        }
        if (cn.equals("[C")) {
            return "char[]";
        }
        if (cn.equals("[D")) {
            return "double[]";
        }
        if (cn.equals("[F")) {
            return "float[]";
        }
        if (cn.equals("[I")) {
            return "int[]";
        }
        if (cn.equals("[J")) {
            return "long[]";
        }
        if (cn.equals("[S")) {
            return "short[]";
        }
        if (cn.equals("[Z")) {
            return "boolean[]";
        }
        if (cn.startsWith("[L")) {
            return cn.substring(2, cn.length() - 1) + "[]";
        }
        return cn;
    }
}

