/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.generator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.altrmi.common.MethodNameHelper;
import org.apache.altrmi.generator.AbstractProxyGenerator;
import org.apache.altrmi.server.PublicationDescriptionItem;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class BCELProxyGeneratorImpl
extends AbstractProxyGenerator {
    private static final String STUB_PREFIX = "AltrmiGenerated";
    private InstructionFactory m_factory;
    private ConstantPoolGen m_constantsPool;
    private ClassGen m_classGen;
    private ArrayList m_internalFieldRepresentingClasses;

    public void generateClass(ClassLoader classLoader) {
        this.generateProxyClass(STUB_PREFIX + this.getGenName() + "_Main", this.getInterfacesToExpose());
        if (this.getAdditionalFacades() != null) {
            for (int i = 0; i < this.getAdditionalFacades().length; ++i) {
                String encodedClassName = MethodNameHelper.encodeClassName((Class)this.getAdditionalFacades()[i].getFacadeClass());
                this.generateProxyClass(STUB_PREFIX + this.getGenName() + "_" + encodedClassName, new PublicationDescriptionItem[]{this.getAdditionalFacades()[i]});
            }
        }
    }

    protected void generateProxyClass(String mGeneratedClassName, PublicationDescriptionItem[] interfacesToStubify) {
        this.createNewClassDeclaration(mGeneratedClassName, interfacesToStubify);
        this.createConstructor(mGeneratedClassName);
        this.createFields();
        this.createGetReferenceIDMethod(mGeneratedClassName);
        this.createHelperMethodForDotClassCalls(mGeneratedClassName);
        this.createInterfaceMethods(mGeneratedClassName, interfacesToStubify);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.getClassGenDir() + "/" + mGeneratedClassName + ".class");
            this.m_classGen.getJavaClass().dump((OutputStream)fos);
            fos.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected void createNewClassDeclaration(String generatedClassName, PublicationDescriptionItem[] interfacesToStubify) {
        String[] interfaces = new String[interfacesToStubify.length + 1];
        for (int i = 0; i < interfacesToStubify.length; ++i) {
            PublicationDescriptionItem publicationDescriptionItem = interfacesToStubify[i];
            interfaces[i] = publicationDescriptionItem.getFacadeClass().getName();
        }
        interfaces[interfacesToStubify.length] = "org.apache.altrmi.client.Proxy";
        this.m_classGen = new ClassGen(generatedClassName, "java.lang.Object", generatedClassName + ".java", 49, interfaces);
        this.m_constantsPool = this.m_classGen.getConstantPool();
        this.m_factory = new InstructionFactory(this.m_classGen, this.m_constantsPool);
        this.m_internalFieldRepresentingClasses = new ArrayList();
    }

    protected void createConstructor(String generatedClassName) {
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(1, (Type)Type.VOID, new Type[]{new ObjectType("org.apache.altrmi.client.ProxyHelper")}, new String[]{"arg0"}, "<init>", generatedClassName, il, this.m_constantsPool);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((Instruction)this.m_factory.createInvoke("java.lang.Object", "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)1));
        il.append((Instruction)this.m_factory.createFieldAccess(generatedClassName, "m_proxyHelper", (Type)new ObjectType("org.apache.altrmi.client.ProxyHelper"), (short)181));
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        method.setMaxStack();
        method.setMaxLocals();
        this.m_classGen.addMethod(method.getMethod());
        il.dispose();
    }

    protected void createFields() {
        FieldGen field = new FieldGen(130, (Type)new ObjectType("org.apache.altrmi.client.ProxyHelper"), "m_proxyHelper", this.m_constantsPool);
        this.m_classGen.addField(field.getField());
    }

    protected void createGetReferenceIDMethod(String generatedClassName) {
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(1, (Type)new ObjectType("java.lang.Long"), new Type[]{Type.OBJECT}, new String[]{"arg0"}, "altrmiGetReferenceID", generatedClassName, il, this.m_constantsPool);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((Instruction)this.m_factory.createFieldAccess(generatedClassName, "m_proxyHelper", (Type)new ObjectType("org.apache.altrmi.client.ProxyHelper"), (short)180));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)1));
        il.append((Instruction)this.m_factory.createInvoke("org.apache.altrmi.client.ProxyHelper", "getReferenceID", (Type)new ObjectType("java.lang.Long"), new Type[]{Type.OBJECT}, (short)185));
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.OBJECT));
        method.setMaxStack();
        method.setMaxLocals();
        this.m_classGen.addMethod(method.getMethod());
        il.dispose();
    }

    protected void createHelperMethodForDotClassCalls(String generatedClassName) {
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(8, (Type)new ObjectType("java.lang.Class"), new Type[]{Type.STRING}, new String[]{"arg0"}, "class$", generatedClassName, il, this.m_constantsPool);
        InstructionHandle ih0 = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((Instruction)this.m_factory.createInvoke("java.lang.Class", "forName", (Type)new ObjectType("java.lang.Class"), new Type[]{Type.STRING}, (short)184));
        InstructionHandle ih4 = il.append((Instruction)InstructionFactory.createReturn((Type)Type.OBJECT));
        InstructionHandle ih5 = il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)1));
        il.append((Instruction)this.m_factory.createNew("java.lang.NoClassDefFoundError"));
        il.append((Instruction)InstructionConstants.DUP);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)1));
        il.append((Instruction)this.m_factory.createInvoke("java.lang.Throwable", "getMessage", (Type)Type.STRING, Type.NO_ARGS, (short)182));
        il.append((Instruction)this.m_factory.createInvoke("java.lang.NoClassDefFoundError", "<init>", (Type)Type.VOID, new Type[]{Type.STRING}, (short)183));
        il.append(InstructionConstants.ATHROW);
        method.addExceptionHandler(ih0, ih4, ih5, new ObjectType("java.lang.ClassNotFoundException"));
        method.setMaxStack();
        method.setMaxLocals();
        this.m_classGen.addMethod(method.getMethod());
        il.dispose();
    }

    protected void createInterfaceMethods(String generatedClassName, PublicationDescriptionItem[] interfacesToStubify) {
        for (int x = 0; x < interfacesToStubify.length; ++x) {
            Class clazz = interfacesToStubify[x].getFacadeClass();
            if (this.isVerbose()) {
                System.out.println("ProxyGen: Processing interface: " + clazz.getName());
            }
            Method[] methods = this.getGeneratableMethods(clazz);
            this.generateEqualsMethod(generatedClassName);
            for (int i = 0; i < methods.length; ++i) {
                this.createInterfaceMethod(generatedClassName, methods[i], interfacesToStubify[x]);
            }
        }
    }

    protected void createInterfaceMethod(String generatedClassName, Method mth, PublicationDescriptionItem interfaceToStubify) {
        BranchHandle ihe2;
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(1, this.getReturnType(mth), this.getArguments(mth), this.getArgumentNames(mth), mth.getName(), generatedClassName, il, this.m_constantsPool);
        Class[] paramTypes = mth.getParameterTypes();
        int numberOfArguments = paramTypes.length;
        int variableIndex = this.getFreeIndexToStart(paramTypes);
        il.append((CompoundInstruction)new PUSH(this.m_constantsPool, numberOfArguments));
        il.append(this.m_factory.createNewArray((Type)Type.OBJECT, (short)1));
        il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)(++variableIndex)));
        il.append((CompoundInstruction)new PUSH(this.m_constantsPool, numberOfArguments));
        il.append(this.m_factory.createNewArray((Type)new ObjectType("java.lang.Class"), (short)1));
        il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)(++variableIndex)));
        this.createInterfaceMethodArgs(numberOfArguments, il, variableIndex, paramTypes, generatedClassName);
        InstructionHandle ih_rollback = null;
        InstructionHandle catchHandler = null;
        BranchInstruction gotoCall = null;
        BranchHandle ih_tryEnd = null;
        if (interfaceToStubify.isRollback(mth)) {
            ih_rollback = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
            il.append((Instruction)this.m_factory.createFieldAccess(generatedClassName, "m_proxyHelper", (Type)new ObjectType("org.apache.altrmi.client.ProxyHelper"), (short)180));
            il.append((Instruction)this.m_factory.createInvoke("org.apache.altrmi.client.ProxyHelper", "rollbackAsyncRequests", (Type)Type.VOID, Type.NO_ARGS, (short)185));
            gotoCall = InstructionFactory.createBranchInstruction((short)167, null);
            ih_tryEnd = il.append(gotoCall);
            catchHandler = il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)(++variableIndex)));
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)variableIndex));
            this.injectCommonExceptionCatchBlock(il, method, variableIndex);
            --variableIndex;
        }
        InstructionHandle ihe1 = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        if (interfaceToStubify.isRollback(mth)) {
            gotoCall.setTarget(ihe1);
            method.addExceptionHandler(ih_rollback, ih_tryEnd, catchHandler, new ObjectType("java.lang.Throwable"));
        }
        il.append((Instruction)this.m_factory.createFieldAccess(generatedClassName, "m_proxyHelper", (Type)new ObjectType("org.apache.altrmi.client.ProxyHelper"), (short)180));
        Class<?> returnClass = mth.getReturnType();
        if (returnClass.isArray()) {
            returnClass = returnClass.getComponentType();
        }
        if (this.isAdditionalFacade(mth.getReturnType())) {
            String encodedReturnClassName = "class$" + MethodNameHelper.encodeClassName(returnClass);
            this.addField(encodedReturnClassName);
            il.append((Instruction)this.m_factory.createFieldAccess(generatedClassName, encodedReturnClassName, (Type)new ObjectType("java.lang.Class"), (short)178));
            BranchInstruction ifnullReturnClass = InstructionFactory.createBranchInstruction((short)198, null);
            il.append(ifnullReturnClass);
            il.append((Instruction)this.m_factory.createFieldAccess(generatedClassName, encodedReturnClassName, (Type)new ObjectType("java.lang.Class"), (short)178));
            BranchInstruction gotoReturnClass = InstructionFactory.createBranchInstruction((short)167, null);
            il.append(gotoReturnClass);
            InstructionHandle ihPushMethodName = il.append((CompoundInstruction)new PUSH(this.m_constantsPool, returnClass.getName()));
            ifnullReturnClass.setTarget(ihPushMethodName);
            il.append((Instruction)this.m_factory.createInvoke(generatedClassName, "class$", (Type)new ObjectType("java.lang.Class"), new Type[]{Type.STRING}, (short)184));
            il.append((Instruction)InstructionConstants.DUP);
            il.append((Instruction)this.m_factory.createFieldAccess(generatedClassName, encodedReturnClassName, (Type)new ObjectType("java.lang.Class"), (short)179));
            InstructionHandle ihPushSignature = il.append((CompoundInstruction)new PUSH(this.m_constantsPool, MethodNameHelper.getMethodSignature((Method)mth)));
            gotoReturnClass.setTarget(ihPushSignature);
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)(variableIndex - 1)));
            il.append((CompoundInstruction)new PUSH(this.m_constantsPool, MethodNameHelper.encodeClassName((String)this.getClassType(returnClass))));
            il.append((Instruction)this.m_factory.createInvoke("org.apache.altrmi.client.ProxyHelper", "processObjectRequestGettingFacade", (Type)Type.OBJECT, new Type[]{new ObjectType("java.lang.Class"), Type.STRING, new ArrayType((Type)Type.OBJECT, 1), Type.STRING}, (short)185));
        } else {
            il.append((CompoundInstruction)new PUSH(this.m_constantsPool, MethodNameHelper.getMethodSignature((Method)mth)));
            variableIndex -= 2;
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)(++variableIndex)));
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)(++variableIndex)));
            if (interfaceToStubify.isAsync(mth)) {
                il.append((Instruction)this.m_factory.createInvoke("org.apache.altrmi.client.ProxyHelper", "queueAsyncRequest", (Type)Type.VOID, new Type[]{Type.STRING, new ArrayType((Type)Type.OBJECT, 1), new ArrayType((Type)new ObjectType("java.lang.Class"), 1)}, (short)185));
            } else if (this.getBCELPrimitiveType(mth.getReturnType().getName()) == Type.VOID) {
                il.append((Instruction)this.m_factory.createInvoke("org.apache.altrmi.client.ProxyHelper", "processVoidRequest", (Type)Type.VOID, new Type[]{Type.STRING, new ArrayType((Type)Type.OBJECT, 1), new ArrayType((Type)new ObjectType("java.lang.Class"), 1)}, (short)185));
            } else {
                il.append((Instruction)this.m_factory.createInvoke("org.apache.altrmi.client.ProxyHelper", "processObjectRequest", (Type)Type.OBJECT, new Type[]{Type.STRING, new ArrayType((Type)Type.OBJECT, 1), new ArrayType((Type)new ObjectType("java.lang.Class"), 1)}, (short)185));
                il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)(++variableIndex)));
                il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)variableIndex));
            }
        }
        if (interfaceToStubify.isCommit(mth)) {
            gotoCall = InstructionFactory.createBranchInstruction((short)167, null);
            ihe2 = il.append(gotoCall);
            ++variableIndex;
        } else if (mth.getReturnType().isPrimitive()) {
            if (this.getBCELPrimitiveType(mth.getReturnType().getName()) == Type.VOID) {
                ihe2 = il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
            } else {
                il.append((Instruction)this.m_factory.createCheckCast((ReferenceType)new ObjectType(this.getJavaWrapperClass(mth.getReturnType().getName()))));
                il.append((Instruction)this.m_factory.createInvoke(this.getJavaWrapperClass(mth.getReturnType().getName()), mth.getReturnType().getName() + "Value", this.getBCELPrimitiveType(mth.getReturnType().getName()), Type.NO_ARGS, (short)182));
                ihe2 = il.append((Instruction)InstructionFactory.createReturn((Type)this.getBCELPrimitiveType(mth.getReturnType().getName())));
            }
        } else {
            il.append((Instruction)this.m_factory.createCheckCast((ReferenceType)new ObjectType(mth.getReturnType().getName())));
            ihe2 = il.append((Instruction)InstructionFactory.createReturn((Type)Type.OBJECT));
        }
        InstructionHandle ihe3 = il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)variableIndex));
        Class<?>[] exceptionClasses = mth.getExceptionTypes();
        InstructionHandle customHandler = null;
        BranchInstruction ifCustomExceptionBranch = null;
        for (int i = 0; i < exceptionClasses.length; ++i) {
            customHandler = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)variableIndex));
            if (ifCustomExceptionBranch != null) {
                ifCustomExceptionBranch.setTarget(customHandler);
            }
            il.append((Instruction)new INSTANCEOF(this.m_constantsPool.addClass(new ObjectType(exceptionClasses[i].getName()))));
            ifCustomExceptionBranch = InstructionFactory.createBranchInstruction((short)153, null);
            il.append(ifCustomExceptionBranch);
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)variableIndex));
            il.append((Instruction)this.m_factory.createCheckCast((ReferenceType)new ObjectType(exceptionClasses[i].getName())));
            il.append(InstructionConstants.ATHROW);
        }
        InstructionHandle defaultExceptionHandler = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)variableIndex));
        if (customHandler != null) {
            ifCustomExceptionBranch.setTarget(defaultExceptionHandler);
        }
        this.injectCommonExceptionCatchBlock(il, method, variableIndex);
        method.addExceptionHandler(ihe1, (InstructionHandle)ihe2, ihe3, new ObjectType("java.lang.Throwable"));
        if (interfaceToStubify.isCommit(mth)) {
            InstructionHandle ih_commit = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
            gotoCall.setTarget(ih_commit);
            il.append((Instruction)this.m_factory.createFieldAccess(generatedClassName, "m_proxyHelper", (Type)new ObjectType("org.apache.altrmi.client.ProxyHelper"), (short)180));
            il.append((Instruction)this.m_factory.createInvoke("org.apache.altrmi.client.ProxyHelper", "commitAsyncRequests", (Type)Type.VOID, Type.NO_ARGS, (short)185));
            InstructionHandle ih_return = il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
            catchHandler = il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)variableIndex));
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)variableIndex));
            this.injectCommonExceptionCatchBlock(il, method, variableIndex);
            method.addExceptionHandler(ih_commit, ih_return, catchHandler, new ObjectType("java.lang.Throwable"));
        }
        method.setMaxStack();
        method.setMaxLocals();
        this.m_classGen.addMethod(method.getMethod());
        il.dispose();
    }

    private void generateEqualsMethod(String generatedClassName) {
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(1, (Type)Type.BOOLEAN, new Type[]{Type.OBJECT}, new String[]{"arg0"}, "equals", generatedClassName, il, this.m_constantsPool);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((Instruction)this.m_factory.createFieldAccess(generatedClassName, "m_proxyHelper", (Type)new ObjectType("org.apache.altrmi.client.ProxyHelper"), (short)180));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)1));
        il.append((Instruction)this.m_factory.createInvoke("org.apache.altrmi.client.ProxyHelper", "isEquals", (Type)Type.BOOLEAN, new Type[]{Type.OBJECT, Type.OBJECT}, (short)185));
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.INT));
        method.setMaxStack();
        method.setMaxLocals();
        this.m_classGen.addMethod(method.getMethod());
        il.dispose();
    }

    private void createInterfaceMethodArgs(int numberOfArguments, InstructionList il, int variableIndex, Class[] paramTypes, String generatedClassName) {
        Type previousType = null;
        int loadIndex = 0;
        for (int i = 0; i < numberOfArguments; ++i) {
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)(variableIndex - 1)));
            il.append((CompoundInstruction)new PUSH(this.m_constantsPool, i));
            String className = paramTypes[i].getName();
            if (previousType != null && (previousType == Type.DOUBLE || previousType == Type.LONG)) {
                ++loadIndex;
            }
            if (paramTypes[i].isPrimitive()) {
                il.append((Instruction)this.m_factory.createNew(this.getJavaWrapperClass(className)));
                il.append((Instruction)InstructionConstants.DUP);
                il.append((Instruction)InstructionFactory.createLoad((Type)this.getBCELPrimitiveType(className), (int)(++loadIndex)));
                il.append((Instruction)this.m_factory.createInvoke(this.getJavaWrapperClass(className), "<init>", (Type)Type.VOID, new Type[]{this.getBCELPrimitiveType(className)}, (short)183));
                il.append((Instruction)InstructionConstants.AASTORE);
            } else {
                int index;
                String encodedFieldName = paramTypes[i].isArray() ? (className.charAt((index = className.lastIndexOf(91)) + 1) == 'L' ? "array$" + className.substring(1 + index, className.length() - 1).replace('.', '$') : "array$" + className.substring(1 + index, className.length())) : "class$" + className.replace('.', '$');
                this.addField(encodedFieldName);
                il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)(variableIndex - 1)));
                il.append((CompoundInstruction)new PUSH(this.m_constantsPool, i));
                il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)(++loadIndex)));
                il.append((Instruction)InstructionConstants.AASTORE);
                il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)variableIndex));
                il.append((CompoundInstruction)new PUSH(this.m_constantsPool, i));
                il.append((Instruction)this.m_factory.createFieldAccess(generatedClassName, encodedFieldName, (Type)new ObjectType("java.lang.Class"), (short)178));
                BranchInstruction ifnull = InstructionFactory.createBranchInstruction((short)198, null);
                il.append(ifnull);
                il.append((Instruction)this.m_factory.createFieldAccess(generatedClassName, encodedFieldName, (Type)new ObjectType("java.lang.Class"), (short)178));
                BranchInstruction goHeadToStoreRef = InstructionFactory.createBranchInstruction((short)167, null);
                il.append(goHeadToStoreRef);
                InstructionHandle ifnullStartHere = il.append((CompoundInstruction)new PUSH(this.m_constantsPool, className));
                ifnull.setTarget(ifnullStartHere);
                il.append((Instruction)this.m_factory.createInvoke(generatedClassName, "class$", (Type)new ObjectType("java.lang.Class"), new Type[]{Type.STRING}, (short)184));
                il.append((Instruction)InstructionConstants.DUP);
                il.append((Instruction)this.m_factory.createFieldAccess(generatedClassName, encodedFieldName, (Type)new ObjectType("java.lang.Class"), (short)179));
                InstructionHandle storeClassRef = il.append((Instruction)InstructionConstants.AASTORE);
                goHeadToStoreRef.setTarget(storeClassRef);
            }
            previousType = this.getBCELPrimitiveType(className);
        }
    }

    public void injectCommonExceptionCatchBlock(InstructionList il, MethodGen method, int variableIndex) {
        il.append((Instruction)new INSTANCEOF(this.m_constantsPool.addClass(new ObjectType("java.lang.RuntimeException"))));
        BranchInstruction b1 = InstructionFactory.createBranchInstruction((short)153, null);
        il.append(b1);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)variableIndex));
        il.append((Instruction)this.m_factory.createCheckCast((ReferenceType)new ObjectType("java.lang.RuntimeException")));
        il.append(InstructionConstants.ATHROW);
        InstructionHandle ih1 = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)variableIndex));
        il.append((Instruction)new INSTANCEOF(this.m_constantsPool.addClass(new ObjectType("java.lang.Error"))));
        BranchInstruction b2 = InstructionFactory.createBranchInstruction((short)153, null);
        il.append(b2);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)variableIndex));
        il.append((Instruction)this.m_factory.createCheckCast((ReferenceType)new ObjectType("java.lang.Error")));
        il.append(InstructionConstants.ATHROW);
        InstructionHandle ih2 = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)variableIndex));
        il.append((Instruction)this.m_factory.createInvoke("java.lang.Throwable", "printStackTrace", (Type)Type.VOID, Type.NO_ARGS, (short)182));
        il.append((Instruction)this.m_factory.createNew("org.apache.altrmi.client.InvocationException"));
        il.append((Instruction)InstructionConstants.DUP);
        il.append((Instruction)this.m_factory.createNew("java.lang.StringBuffer"));
        il.append((Instruction)InstructionConstants.DUP);
        il.append((CompoundInstruction)new PUSH(this.m_constantsPool, "Should never get here: "));
        il.append((Instruction)this.m_factory.createInvoke("java.lang.StringBuffer", "<init>", (Type)Type.VOID, new Type[]{Type.STRING}, (short)183));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)variableIndex));
        il.append((Instruction)this.m_factory.createInvoke("java.lang.Throwable", "getMessage", (Type)Type.STRING, Type.NO_ARGS, (short)182));
        il.append((Instruction)this.m_factory.createInvoke("java.lang.StringBuffer", "append", (Type)Type.STRINGBUFFER, new Type[]{Type.STRING}, (short)182));
        il.append((Instruction)this.m_factory.createInvoke("java.lang.StringBuffer", "toString", (Type)Type.STRING, Type.NO_ARGS, (short)182));
        il.append((Instruction)this.m_factory.createInvoke("org.apache.altrmi.client.InvocationException", "<init>", (Type)Type.VOID, new Type[]{Type.STRING}, (short)183));
        il.append(InstructionConstants.ATHROW);
        b1.setTarget(ih1);
        b2.setTarget(ih2);
    }

    protected int getFreeIndexToStart(Class[] classes) {
        int index = 0;
        for (int i = 0; i < classes.length; ++i) {
            if (this.getBCELType(classes[i]) == Type.DOUBLE || this.getBCELType(classes[i]) == Type.LONG) {
                index += 2;
            }
            ++index;
        }
        return index;
    }

    protected Type[] getArguments(Method method) {
        Class<?>[] classes = method.getParameterTypes();
        if (classes.length == 0) {
            return Type.NO_ARGS;
        }
        Type[] types = new Type[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            types[i] = this.getBCELType(classes[i]);
        }
        return types;
    }

    protected Type getReturnType(Method method) {
        return this.getBCELType(method.getReturnType());
    }

    protected String[] getArgumentNames(Method method) {
        Class<?>[] classes = method.getParameterTypes();
        String[] args = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            args[i] = "arg" + i;
        }
        return args;
    }

    protected Type getBCELType(Class clazz) {
        if (clazz.isPrimitive()) {
            return this.getBCELPrimitiveType(clazz.getName());
        }
        if (!clazz.isArray()) {
            return new ObjectType(clazz.getName());
        }
        String className = clazz.getName();
        int index = className.lastIndexOf(91);
        int arrayDepth = className.indexOf(91) - className.lastIndexOf(91) + 1;
        if (className.charAt(index + 1) == 'L') {
            return new ArrayType((Type)new ObjectType(clazz.getComponentType().getName()), arrayDepth);
        }
        return new ArrayType(this.getBCELPrimitiveType(className.substring(arrayDepth)), arrayDepth);
    }

    protected Type getBCELPrimitiveType(String javaDataType) {
        switch (javaDataType.charAt(0)) {
            case 'b': {
                if (javaDataType.toString().charAt(1) == 'o') {
                    return Type.BOOLEAN;
                }
                return Type.BYTE;
            }
            case 'C': 
            case 'c': {
                return Type.CHAR;
            }
            case 'S': 
            case 's': {
                return Type.SHORT;
            }
            case 'I': 
            case 'i': {
                return Type.INT;
            }
            case 'L': 
            case 'l': {
                return Type.LONG;
            }
            case 'F': 
            case 'f': {
                return Type.FLOAT;
            }
            case 'D': 
            case 'd': {
                return Type.DOUBLE;
            }
            case 'Z': {
                return Type.BOOLEAN;
            }
            case 'B': {
                return Type.BYTE;
            }
            case 'V': 
            case 'v': {
                return Type.VOID;
            }
        }
        return null;
    }

    protected String getJavaWrapperClass(String javaDataType) {
        switch (javaDataType.charAt(0)) {
            case 'b': {
                if (javaDataType.charAt(1) == 'o') {
                    return "java.lang.Boolean";
                }
                return "java.lang.Byte";
            }
            case 'C': 
            case 'c': {
                return "java.lang.Character";
            }
            case 'S': 
            case 's': {
                return "java.lang.Short";
            }
            case 'I': 
            case 'i': {
                return "java.lang.Integer";
            }
            case 'L': 
            case 'l': {
                return "java.lang.Long";
            }
            case 'F': 
            case 'f': {
                return "java.lang.Float";
            }
            case 'D': 
            case 'd': {
                return "java.lang.Double";
            }
            case 'B': {
                return "java.lang.Byte";
            }
            case 'Z': {
                return "java.lang.Boolean";
            }
            case 'V': 
            case 'v': {
                return "java.lang.Void";
            }
            case '[': {
                return this.getJavaWrapperClass(javaDataType.substring(1));
            }
        }
        return null;
    }

    protected void addField(String encodedFieldName) {
        if (!this.m_internalFieldRepresentingClasses.contains(encodedFieldName)) {
            FieldGen field = new FieldGen(8, (Type)new ObjectType("java.lang.Class"), encodedFieldName, this.m_constantsPool);
            this.m_classGen.addField(field.getField());
            this.m_internalFieldRepresentingClasses.add(encodedFieldName);
        }
    }

    protected void createTestMethod(InstructionList il, String msg) {
        il.append((Instruction)this.m_factory.createFieldAccess("java.lang.System", "out", (Type)new ObjectType("java.io.PrintStream"), (short)178));
        il.append((CompoundInstruction)new PUSH(this.m_constantsPool, msg));
        il.append((Instruction)this.m_factory.createInvoke("java.io.PrintStream", "println", (Type)Type.VOID, new Type[]{Type.STRING}, (short)182));
    }

    protected void debug(String prefix, Object[] objArray) {
        System.out.print(prefix);
        for (int i = 0; i < objArray.length; ++i) {
            System.out.print(objArray[i] + ":");
        }
        System.out.println();
    }

    public Class getGeneratedClass(String generatedClassName) {
        return this.getProxyClass(generatedClassName);
    }

    protected Class getProxyClass(String className) {
        Class<?> clazz = null;
        try {
            URLClassLoader urlCL = new URLClassLoader(new URL[]{new URL("file:/" + new File(this.getClassGenDir()).getCanonicalPath() + "/")}, this.getClass().getClassLoader());
            clazz = urlCL.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return clazz;
    }
}

