/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl.stream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import org.apache.altrmi.client.ClientMonitor;
import org.apache.altrmi.client.ConnectionPinger;
import org.apache.altrmi.client.InvocationException;
import org.apache.altrmi.client.NoSuchReferenceException;
import org.apache.altrmi.client.NoSuchSessionException;
import org.apache.altrmi.client.NotPublishedException;
import org.apache.altrmi.client.impl.AbstractClientInvocationHandler;
import org.apache.altrmi.client.impl.ClientStreamReadWriter;
import org.apache.altrmi.common.ClientInvocationAbendReply;
import org.apache.altrmi.common.MethodRequest;
import org.apache.altrmi.common.NoSuchReferenceReply;
import org.apache.altrmi.common.NoSuchSessionReply;
import org.apache.altrmi.common.NotPublishedReply;
import org.apache.altrmi.common.PublishedNameRequest;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;
import org.apache.altrmi.common.ThreadPool;
import org.apache.altrmi.common.TryLaterReply;

public abstract class StreamInvocationHandler
extends AbstractClientInvocationHandler {
    private ClientStreamReadWriter m_objectReadWriter;
    private boolean m_methodLogging = false;
    private long m_lastRealRequest = System.currentTimeMillis();
    protected final ClassLoader m_interfacesClassLoader;

    public StreamInvocationHandler(ThreadPool threadPool, ClientMonitor clientMonitor, ConnectionPinger connectionPinger, ClassLoader interfacesClassLoader) {
        super(threadPool, clientMonitor, connectionPinger);
        this.m_interfacesClassLoader = interfacesClassLoader;
        this.m_methodLogging = clientMonitor.methodLogging();
    }

    public ClassLoader getInterfacesClassLoader() {
        return this.m_interfacesClassLoader;
    }

    protected void setObjectReadWriter(ClientStreamReadWriter objectReadWriter) {
        this.m_objectReadWriter = objectReadWriter;
    }

    protected void requestWritten() {
    }

    public synchronized Reply handleInvocation(Request request) {
        if (request.getRequestCode() != 306) {
            this.m_lastRealRequest = System.currentTimeMillis();
        }
        try {
            boolean again = true;
            Reply reply = null;
            int tries = 0;
            long start = 0L;
            if (this.m_methodLogging) {
                start = System.currentTimeMillis();
            }
            while (again) {
                ++tries;
                again = false;
                try {
                    long t1 = System.currentTimeMillis();
                    reply = this.m_objectReadWriter.postRequest(request);
                    long t2 = System.currentTimeMillis();
                    if (reply.getReplyCode() < 100) continue;
                    if (reply.getReplyCode() == 108) {
                        ClientInvocationAbendReply abendReply = (ClientInvocationAbendReply)reply;
                        throw abendReply.getIOException();
                    }
                    if (reply instanceof TryLaterReply) {
                        int millis = ((TryLaterReply)reply).getSuggestedDelayMillis();
                        this.m_clientMonitor.serviceSuspended(this.getClass(), request, tries, millis);
                        again = true;
                        continue;
                    }
                    if (reply instanceof NoSuchReferenceReply) {
                        throw new NoSuchReferenceException(((NoSuchReferenceReply)reply).getReferenceID());
                    }
                    if (reply instanceof NoSuchSessionReply) {
                        throw new NoSuchSessionException(((NoSuchSessionReply)reply).getSessionID());
                    }
                    if (!(reply instanceof NotPublishedReply)) continue;
                    PublishedNameRequest pnr = (PublishedNameRequest)request;
                    throw new NotPublishedException(pnr.getPublishedServiceName(), pnr.getObjectName());
                }
                catch (IOException ioe) {
                    if (this.isSafeEnd(ioe)) {
                        int retryConnectTries = 0;
                        again = true;
                        while (!this.tryReconnect()) {
                            this.m_clientMonitor.serviceAbend(this.getClass(), retryConnectTries, ioe);
                            ++retryConnectTries;
                        }
                        continue;
                    }
                    ioe.printStackTrace();
                    throw new InvocationException("IO Exception during invocation to server :" + ioe.getMessage());
                }
            }
            if (this.m_methodLogging && request instanceof MethodRequest) {
                this.m_clientMonitor.methodCalled(this.getClass(), ((MethodRequest)request).getMethodSignature(), System.currentTimeMillis() - start, "");
            }
            return reply;
        }
        catch (ClassNotFoundException e) {
            throw new InvocationException("Class definition missing on Deserialization: " + e.getMessage());
        }
    }

    private boolean isSafeEnd(IOException ioe) {
        String msg;
        if (ioe instanceof SocketException | ioe instanceof EOFException | ioe instanceof InterruptedIOException) {
            return true;
        }
        return ioe.getMessage() != null && (msg = ioe.getMessage()).equals("Read end dead") | msg.equals("Pipe closed");
    }

    public long getLastRealRequest() {
        return this.m_lastRealRequest;
    }
}

