/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl.stream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.altrmi.client.impl.ClientStreamReadWriter;
import org.apache.altrmi.common.BadConnectionException;
import org.apache.altrmi.common.ConnectionException;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;

public class ClientObjectStreamReadWriter
implements ClientStreamReadWriter {
    private ObjectInputStream m_objectInputStream;
    private ObjectOutputStream m_objectOutputStream;

    public ClientObjectStreamReadWriter(InputStream inputStream, OutputStream outputStream) throws ConnectionException {
        try {
            this.m_objectOutputStream = new ObjectOutputStream(outputStream);
            this.m_objectInputStream = new ObjectInputStream(inputStream);
        }
        catch (EOFException eofe) {
            throw new BadConnectionException("Cannot connect to remote AltRMI server. Have we a mismatch on transports?");
        }
        catch (IOException ioe) {
            throw new ConnectionException("Some problem instantiating ObjectStream classes: " + ioe.getMessage());
        }
    }

    public synchronized Reply postRequest(Request request) throws IOException, ClassNotFoundException {
        this.writeRequest(request);
        return this.readReply();
    }

    private void writeRequest(Request request) throws IOException {
        this.m_objectOutputStream.writeObject(request);
        this.m_objectOutputStream.flush();
    }

    private Reply readReply() throws IOException, ClassNotFoundException {
        return (Reply)this.m_objectInputStream.readObject();
    }
}

