/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl.stream;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.altrmi.client.impl.ClientStreamReadWriter;
import org.apache.altrmi.common.ConnectionException;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;
import org.apache.altrmi.common.SerializationHelper;

public class ClientCustomStreamReadWriter
implements ClientStreamReadWriter {
    private DataInputStream m_dataInputStream;
    private DataOutputStream m_dataOutputStream;
    private ClassLoader m_interfacesClassLoader;

    public ClientCustomStreamReadWriter(InputStream inputStream, OutputStream outputStream, ClassLoader interfacesClassLoader) throws ConnectionException {
        this.m_dataOutputStream = new DataOutputStream(new BufferedOutputStream(outputStream));
        this.m_dataInputStream = new DataInputStream(inputStream);
        this.m_interfacesClassLoader = interfacesClassLoader;
    }

    public synchronized Reply postRequest(Request request) throws IOException, ClassNotFoundException {
        this.writeRequest(request);
        Reply r = this.readReply();
        return r;
    }

    private void writeRequest(Request request) throws IOException {
        byte[] aBytes = SerializationHelper.getBytesFromInstance((Object)request);
        this.m_dataOutputStream.writeInt(aBytes.length);
        this.m_dataOutputStream.write(aBytes);
        this.m_dataOutputStream.flush();
    }

    private Reply readReply() throws IOException, ClassNotFoundException {
        int byteArraySize = this.m_dataInputStream.readInt();
        byte[] byteArray = new byte[byteArraySize];
        int pos = 0;
        int cnt = 0;
        while (pos < byteArraySize) {
            int read = this.m_dataInputStream.read(byteArray, pos, byteArraySize - pos);
            pos += read;
            ++cnt;
        }
        return (Reply)SerializationHelper.getInstanceFromBytes((byte[])byteArray, (ClassLoader)this.m_interfacesClassLoader);
    }
}

