/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl.messenger;

import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.apache.altrmi.client.ClientMonitor;
import org.apache.altrmi.client.ConnectionPinger;
import org.apache.altrmi.client.NoSuchReferenceException;
import org.apache.altrmi.client.NotPublishedException;
import org.apache.altrmi.client.impl.AbstractClientInvocationHandler;
import org.apache.altrmi.common.AltrmiRuntimeException;
import org.apache.altrmi.common.MethodRequest;
import org.apache.altrmi.common.NoSuchReferenceReply;
import org.apache.altrmi.common.NotPublishedReply;
import org.apache.altrmi.common.PublishedNameRequest;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;
import org.apache.altrmi.common.ThreadPool;
import org.apache.altrmi.common.TryLaterReply;
import org.apache.commons.messenger.Messenger;

public final class SynchronousMessengerClientInvocationHandler
extends AbstractClientInvocationHandler {
    private boolean m_methodLogging = false;
    private long m_lastRealRequest = System.currentTimeMillis();
    private Messenger m_clientMessenger;
    private String m_subject;
    private Destination m_destination;
    private long timeout = 4000L;
    private int correlationID = 0;

    public SynchronousMessengerClientInvocationHandler(ThreadPool threadPool, ClientMonitor clientMonitor, ConnectionPinger connectionPinger, Messenger clientMessenger, String subject) throws JMSException {
        super(threadPool, clientMonitor, connectionPinger);
        this.m_clientMessenger = clientMessenger;
        this.m_subject = subject;
        this.m_destination = this.m_clientMessenger.getDestination(this.m_subject);
    }

    protected boolean tryReconnect() {
        return true;
    }

    public synchronized Reply handleInvocation(Request request) {
        if (request.getRequestCode() != 306) {
            this.m_lastRealRequest = System.currentTimeMillis();
        }
        boolean again = true;
        Reply reply = null;
        int tries = 0;
        long start = 0L;
        if (this.m_methodLogging) {
            start = System.currentTimeMillis();
        }
        while (again) {
            ++tries;
            again = false;
            reply = this.handleJMSInvocation(request);
            if (reply.getReplyCode() < 100) continue;
            if (reply instanceof TryLaterReply) {
                int millis = ((TryLaterReply)reply).getSuggestedDelayMillis();
                this.m_clientMonitor.serviceSuspended(this.getClass(), request, tries, millis);
                again = true;
                continue;
            }
            if (reply instanceof NoSuchReferenceReply) {
                throw new NoSuchReferenceException(((NoSuchReferenceReply)reply).getReferenceID());
            }
            if (!(reply instanceof NotPublishedReply)) continue;
            PublishedNameRequest pnr = (PublishedNameRequest)request;
            throw new NotPublishedException(pnr.getPublishedServiceName(), pnr.getObjectName());
        }
        if (this.m_methodLogging && request instanceof MethodRequest) {
            this.m_clientMonitor.methodCalled(this.getClass(), ((MethodRequest)request).getMethodSignature(), System.currentTimeMillis() - start, "");
        }
        return reply;
    }

    public String getCorrelationID() {
        return "altrmi-" + this.correlationID++;
    }

    private Reply handleJMSInvocation(Request request) {
        try {
            Message response;
            ObjectMessage message = this.m_clientMessenger.createObjectMessage((Serializable)request);
            message.setJMSCorrelationID(this.getCorrelationID());
            Message message2 = response = this.timeout > 0L ? this.m_clientMessenger.call(this.m_destination, (Message)message, this.timeout) : this.m_clientMessenger.call(this.m_destination, (Message)message);
            if (response == null) {
                throw new AltrmiRuntimeException("Request timed out");
            }
            if (response instanceof ObjectMessage) {
                ObjectMessage objectMessage = (ObjectMessage)response;
                return (Reply)objectMessage.getObject();
            }
            throw new AltrmiRuntimeException("Wrong return type from Messenger");
        }
        catch (JMSException e) {
            throw new AltrmiRuntimeException("JMSException during invocation:" + e.getMessage());
        }
    }

    public long getLastRealRequest() {
        return this.m_lastRealRequest;
    }
}

