/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl.direct;

import java.io.IOException;
import org.apache.altrmi.client.ClientMonitor;
import org.apache.altrmi.client.ConnectionPinger;
import org.apache.altrmi.client.impl.direct.AbstractDirectInvocationHandler;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;
import org.apache.altrmi.common.RequestFailedReply;
import org.apache.altrmi.common.SerializationHelper;
import org.apache.altrmi.common.ThreadPool;
import org.apache.altrmi.server.ServerMarshalledInvocationHandler;

public final class DirectMarshalledInvocationHandler
extends AbstractDirectInvocationHandler {
    private ServerMarshalledInvocationHandler m_invocationHandler;
    private ClassLoader m_interfacesClassLoader;

    public DirectMarshalledInvocationHandler(ThreadPool threadPool, ClientMonitor clientMonitor, ConnectionPinger connectionPinger, ServerMarshalledInvocationHandler invocationHandler, ClassLoader classLoader) {
        super(threadPool, clientMonitor, connectionPinger);
        this.m_invocationHandler = invocationHandler;
        this.m_interfacesClassLoader = classLoader;
    }

    protected Reply performInvocation(Request request) throws IOException {
        try {
            byte[] serRequest = SerializationHelper.getBytesFromInstance((Object)request);
            byte[] serReply = this.m_invocationHandler.handleInvocation(serRequest, null);
            return (Reply)SerializationHelper.getInstanceFromBytes((byte[])serReply, (ClassLoader)this.m_interfacesClassLoader);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return new RequestFailedReply("Some Class not found Exception on server side : " + e.getMessage());
        }
    }

    public ClassLoader getInterfacesClassLoader() {
        return this.m_interfacesClassLoader;
    }
}

