/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl;

import java.io.IOException;
import org.apache.altrmi.client.ClientMonitor;
import org.apache.altrmi.client.ConnectionClosedException;
import org.apache.altrmi.client.InvocationException;
import org.apache.altrmi.common.Request;

public class DefaultClientMonitor
implements ClientMonitor {
    private int m_maxReconnectAttempts;

    public DefaultClientMonitor() {
        this(3);
    }

    public DefaultClientMonitor(int maxReconnectAttempts) {
        this.m_maxReconnectAttempts = maxReconnectAttempts;
    }

    public void methodCalled(Class clazz, String methodSignature, long duration, String annotation) {
    }

    public boolean methodLogging() {
        return false;
    }

    public void serviceSuspended(Class clazz, Request request, int attempt, int suggestedWaitMillis) {
        if (attempt == 10) {
            throw new InvocationException("Too many retries on suspended service");
        }
        this.printMessage("AltRMI service suspended, Trying to reconnect (attempt " + attempt + ", waiting for " + suggestedWaitMillis / 1000 + " seconds)");
        try {
            Thread.sleep(suggestedWaitMillis);
        }
        catch (InterruptedException ie) {
            this.unexpectedInterruption(this.getClass(), this.getClass().getName(), ie);
        }
    }

    public void serviceAbend(Class clazz, int attempt, IOException cause) {
        if (attempt >= this.m_maxReconnectAttempts) {
            String msg;
            if (this.m_maxReconnectAttempts <= 0) {
                msg = "Reconnect to abended service disabled.";
            } else {
                msg = "Too many retries on abended service. ";
                if (cause != null) {
                    msg = msg + "Possible cause of abend (exception=" + cause.getClass().getName() + "). ";
                    msg = cause.getMessage() != null ? msg + "Message= '" + cause.getMessage() + "'" : msg + "No Message in exception.";
                } else {
                    msg = msg + "Unknown cause of abend.";
                }
            }
            throw new InvocationException(msg);
        }
        this.printMessage("AltRMI service abnormally ended, Trying to reconnect (attempt " + attempt + ")");
        try {
            Thread.sleep((2 ^ attempt) * 500);
        }
        catch (InterruptedException ie) {
            this.unexpectedInterruption(this.getClass(), this.getClass().getName(), ie);
        }
    }

    public void invocationFailure(Class clazz, String name, InvocationException ie) {
    }

    public void unexpectedClosedConnection(Class clazz, String name, ConnectionClosedException cce) {
    }

    public void unexpectedInterruption(Class clazz, String name, InterruptedException ie) {
    }

    void printMessage(String message) {
        System.out.println(message);
    }
}

