/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.altrmi.client.HostContext;
import org.apache.altrmi.client.impl.AbstractFactory;
import org.apache.altrmi.client.impl.DefaultProxyHelper;
import org.apache.altrmi.common.ConnectionException;

public class ClientSideClassFactory
extends AbstractFactory {
    public ClientSideClassFactory(HostContext hostContext, boolean allowOptimize) throws ConnectionException {
        super(hostContext, allowOptimize);
    }

    protected Class getFacadeClass(String publishedServiceName, String objectName) throws ConnectionException, ClassNotFoundException {
        String className = "AltrmiGenerated" + publishedServiceName + "_" + objectName;
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return this.getClass().getClassLoader().loadClass(className);
        }
    }

    protected Object getInstance(String publishedServiceName, String objectName, DefaultProxyHelper proxyHelper) throws ConnectionException {
        try {
            Class clazz = this.getFacadeClass(publishedServiceName, objectName);
            Constructor<?>[] constructors = clazz.getConstructors();
            Object retVal = constructors[0].newInstance(proxyHelper);
            return retVal;
        }
        catch (InvocationTargetException ite) {
            throw new ConnectionException("Generated class not instantiated : " + ite.getTargetException().getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConnectionException("Generated class not found during lookup : " + cnfe.getMessage());
        }
        catch (InstantiationException ie) {
            throw new ConnectionException("Generated class not instantiable during lookup : " + ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new ConnectionException("Illegal access to generated class during lookup : " + iae.getMessage());
        }
    }

    public void close() {
        this.m_hostContext.getInvocationHandler().close();
    }
}

