/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl;

import java.lang.ref.WeakReference;
import java.rmi.server.UID;
import java.util.HashMap;
import org.apache.altrmi.client.ClientInvocationHandler;
import org.apache.altrmi.client.Factory;
import org.apache.altrmi.client.HostContext;
import org.apache.altrmi.client.Proxy;
import org.apache.altrmi.client.impl.AbstractHostContext;
import org.apache.altrmi.client.impl.AbstractSameVmBindableHostContext;
import org.apache.altrmi.client.impl.DefaultProxyHelper;
import org.apache.altrmi.common.Authentication;
import org.apache.altrmi.common.ConnectionException;
import org.apache.altrmi.common.ExceptionReply;
import org.apache.altrmi.common.FacadeRefHolder;
import org.apache.altrmi.common.ListReply;
import org.apache.altrmi.common.ListRequest;
import org.apache.altrmi.common.LookupReply;
import org.apache.altrmi.common.LookupRequest;
import org.apache.altrmi.common.NotPublishedReply;
import org.apache.altrmi.common.OpenConnectionReply;
import org.apache.altrmi.common.OpenConnectionRequest;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;
import org.apache.altrmi.common.SameVMReply;

public abstract class AbstractFactory
implements Factory {
    private static final UID U_ID = new UID(20729);
    protected final HostContext m_hostContext;
    protected ClientInvocationHandler m_clientInvocationHandler;
    protected final HashMap m_refObjs = new HashMap();
    private transient String m_textToSign;
    protected Long m_session;

    public AbstractFactory(HostContext hostContext, boolean allowOptimize) throws ConnectionException {
        Reply reply;
        UID machineID;
        this.m_hostContext = hostContext;
        this.m_clientInvocationHandler = this.m_hostContext.getInvocationHandler();
        this.m_clientInvocationHandler.initialize();
        UID uID = machineID = allowOptimize ? U_ID : null;
        if (!(this.m_hostContext instanceof AbstractSameVmBindableHostContext)) {
            machineID = null;
        }
        if ((reply = this.m_clientInvocationHandler.handleInvocation((Request)new OpenConnectionRequest(machineID))) instanceof SameVMReply) {
            if (this.m_hostContext instanceof AbstractSameVmBindableHostContext) {
                AbstractSameVmBindableHostContext sameVmBindableHostContext = (AbstractSameVmBindableHostContext)this.m_hostContext;
                AbstractHostContext hContext = sameVmBindableHostContext.makeSameVmHostContext();
                if (hContext == null) {
                    reply = this.m_clientInvocationHandler.handleInvocation((Request)new OpenConnectionRequest(null));
                } else {
                    this.m_clientInvocationHandler = this.m_hostContext.getInvocationHandler();
                    reply = this.m_clientInvocationHandler.handleInvocation((Request)new OpenConnectionRequest());
                }
            } else {
                throw new ConnectionException("SameVM instruction for non rebindable host context.");
            }
        }
        if (!(reply instanceof OpenConnectionReply)) {
            throw new ConnectionException("Setting of host context blocked for reasons of unknown, server-side reply: (" + reply.getClass().getName() + ")");
        }
        this.m_textToSign = ((OpenConnectionReply)reply).getTextToSign();
        this.m_session = ((OpenConnectionReply)reply).getSession();
    }

    public Object lookup(String publishedServiceName, Authentication altrmiAuthentication) throws ConnectionException {
        Reply ar = this.m_clientInvocationHandler.handleInvocation((Request)new LookupRequest(publishedServiceName, altrmiAuthentication, this.m_session));
        if (ar.getReplyCode() >= 100) {
            if (ar instanceof NotPublishedReply) {
                throw new ConnectionException("Service " + publishedServiceName + " not published");
            }
            if (ar instanceof ExceptionReply) {
                ExceptionReply er = (ExceptionReply)ar;
                throw (ConnectionException)er.getReplyException();
            }
            throw new ConnectionException("Problem doing lookup on service");
        }
        if (ar instanceof ExceptionReply) {
            ExceptionReply er = (ExceptionReply)ar;
            Throwable t = er.getReplyException();
            if (t instanceof ConnectionException) {
                throw (ConnectionException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new ConnectionException("Problem doing lookup on service [exception: " + t.getMessage() + "]");
        }
        if (!(ar instanceof LookupReply)) {
            throw new UnsupportedOperationException("Unexpected reply to lookup [reply: " + ar + "]");
        }
        LookupReply lr = (LookupReply)ar;
        DefaultProxyHelper baseObj = new DefaultProxyHelper(this, this.m_clientInvocationHandler, publishedServiceName, "Main", lr.getReferenceID(), this.m_session);
        Object retVal = this.getInstance(publishedServiceName, "Main", baseObj);
        baseObj.registerImplObject(retVal);
        return retVal;
    }

    protected abstract Class getFacadeClass(String var1, String var2) throws ConnectionException, ClassNotFoundException;

    protected abstract Object getInstance(String var1, String var2, DefaultProxyHelper var3) throws ConnectionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerReferenceObject(Object obj, Long referenceID) {
        AbstractFactory abstractFactory = this;
        synchronized (abstractFactory) {
            this.m_refObjs.put(referenceID, new WeakReference<Object>(obj));
        }
    }

    public final Long getReferenceID(Proxy obj) {
        return obj.altrmiGetReferenceID((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getImplObj(Long referenceID) {
        WeakReference wr = null;
        AbstractFactory abstractFactory = this;
        synchronized (abstractFactory) {
            wr = (WeakReference)this.m_refObjs.get(referenceID);
        }
        if (wr == null) {
            return null;
        }
        Object obj = wr.get();
        if (obj == null) {
            this.m_refObjs.remove(referenceID);
        }
        return obj;
    }

    public final Object lookup(String publishedServiceName) throws ConnectionException {
        return this.lookup(publishedServiceName, null);
    }

    public String getTextToSignForAuthentication() {
        return this.m_textToSign;
    }

    public String[] list() {
        Reply ar = this.m_clientInvocationHandler.handleInvocation((Request)new ListRequest());
        if (ar instanceof ListReply) {
            return ((ListReply)ar).getListOfPublishedObjects();
        }
        return new String[0];
    }

    public boolean hasService(String publishedServiceName) {
        String[] services = this.list();
        for (int i = 0; i < services.length; ++i) {
            String service = services[i];
            if (!service.equals(publishedServiceName)) continue;
            return true;
        }
        return false;
    }

    private FacadeRefHolder makeFacadeRefHolder(Proxy obj, String objectName) {
        Long refID = this.getReferenceID(obj);
        return new FacadeRefHolder(refID, objectName);
    }

    public void marshallCorrection(String methodSignature, Object[] args, Class[] argClasses) {
        for (int i = 0; i < args.length; ++i) {
            Class argClass = argClasses[i];
            if (argClass == null) continue;
            if (args[i] instanceof Proxy) {
                Proxy proxy = (Proxy)args[i];
                if (this.getReferenceID(proxy) == null) continue;
                String objName = args[i].getClass().getName().substring(15);
                args[i] = this.makeFacadeRefHolder(proxy, objName);
                continue;
            }
            args[i] = this.m_clientInvocationHandler.resolveArgument(methodSignature, argClasses[i], args[i]);
        }
    }
}

