/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl;

import org.apache.altrmi.client.ClientInvocationHandler;
import org.apache.altrmi.client.ConnectionClosedException;
import org.apache.altrmi.client.ConnectionPinger;
import org.apache.altrmi.client.InvocationException;
import org.apache.altrmi.common.ThreadContext;

public abstract class AbstractConnectionPinger
implements ConnectionPinger {
    private ClientInvocationHandler m_clientInvocationHandler;
    private boolean m_continue = true;
    private Runnable m_runnable;
    private ThreadContext m_threadContext;
    private final long m_pingInterval;
    private final long m_giveupInterval;

    public AbstractConnectionPinger(int pingIntervalSeconds, int giveupIntervalSeconds) {
        this.m_pingInterval = pingIntervalSeconds * 1000;
        this.m_giveupInterval = giveupIntervalSeconds * 1000;
    }

    public AbstractConnectionPinger(long pingIntervalMilliSeconds, long giveupIntervalMilliSeconds) {
        this.m_pingInterval = pingIntervalMilliSeconds;
        this.m_giveupInterval = giveupIntervalMilliSeconds;
    }

    public AbstractConnectionPinger() {
        this.m_pingInterval = 10000L;
        this.m_giveupInterval = 100000L;
    }

    public void setInvocationHandler(ClientInvocationHandler invocationHandler) {
        this.m_clientInvocationHandler = invocationHandler;
    }

    protected ClientInvocationHandler getInvocationHandler() {
        return this.m_clientInvocationHandler;
    }

    public void start() {
        this.m_runnable = new Runnable(){

            public void run() {
                block5: {
                    try {
                        while (AbstractConnectionPinger.this.m_continue) {
                            Thread.sleep(AbstractConnectionPinger.this.m_pingInterval);
                            AbstractConnectionPinger.this.ping();
                        }
                    }
                    catch (InvocationException ie) {
                        AbstractConnectionPinger.this.m_clientInvocationHandler.getClientMonitor().invocationFailure(this.getClass(), this.getClass().getName(), ie);
                    }
                    catch (ConnectionClosedException cce) {
                        AbstractConnectionPinger.this.m_clientInvocationHandler.getClientMonitor().unexpectedClosedConnection(this.getClass(), this.getClass().getName(), cce);
                    }
                    catch (InterruptedException e) {
                        if (!AbstractConnectionPinger.this.m_continue) break block5;
                        AbstractConnectionPinger.this.m_clientInvocationHandler.getClientMonitor().unexpectedInterruption(this.getClass(), this.getClass().getName(), e);
                    }
                }
            }
        };
        this.m_threadContext = this.m_clientInvocationHandler.getThreadPool().getThreadContext(this.m_runnable);
        this.m_threadContext.start();
    }

    public void stop() {
        this.m_continue = false;
        this.m_threadContext.interrupt();
        this.m_threadContext = null;
    }

    protected abstract void ping();

    public long getGiveupInterval() {
        return this.m_giveupInterval;
    }
}

