package io.taskmonk.entities;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TaskQueryParams {

    List<String> fields = new ArrayList<String>();
    Long startTask;
    Long endTask;
    Date taskCompleteStart;
    Date taskCompleteEnd;
    String taskState;
    Integer pageSize;
    Integer pageNumber;

    public List<String> getFields() {
        return fields;
    }

    public TaskQueryParams setFields(List<String> fields) {
        this.fields = fields;
        return this;
    }

    public Long getStartTask() {
        return startTask;
    }

    public TaskQueryParams setStartTask(Long startTask) {
        this.startTask = startTask;
        return this;
    }

    public Long getEndTask() {
        return endTask;
    }

    public TaskQueryParams setEndTask(Long endTask) {
        this.endTask = endTask;
        return this;
    }

    public Date getTaskCompleteStart() {
        return taskCompleteStart;
    }

    public TaskQueryParams setTaskCompleteStart(Date taskCompleteStart) {
        this.taskCompleteStart = taskCompleteStart;
        return this;
    }

    public Date getTaskCompleteEnd() {
        return taskCompleteEnd;
    }

    public TaskQueryParams setTaskCompleteEnd(Date taskCompleteEnd) {
        this.taskCompleteEnd = taskCompleteEnd;
        return this;
    }

    public String getTaskState() {
        return taskState;
    }

    public TaskQueryParams setTaskState(String taskState) {
        this.taskState = taskState;
        return this;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public TaskQueryParams setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Integer getPageNumber() {
        return pageNumber;
    }

    public TaskQueryParams setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    public List<NameValuePair> getParameters() {
        List<NameValuePair> result = new ArrayList<NameValuePair>();
        if (fields != null && fields.size() > 0) {
            result.add(new BasicNameValuePair("fields", StringUtils.join(fields, ',')));
        }
        return result;
    }
}
