package io.taskmonk.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Task {
    public String batchId;
    public String externalId;
    public Map<String, String> data;

    public Task() {

    }
    public Task(String batchId, String externalId,
                Map<String, String> data) {
        this.batchId = batchId;
        this.externalId = externalId;
        this.data = data;
    }

    @JsonProperty("batch_id")
    public String getBatchId() {
        return batchId;
    }

    @JsonProperty("batch_id")
    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }


    @JsonProperty("external_id")
    public String getExternalId() {
        return externalId;
    }

    @JsonProperty("external_id")
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Map<String, String> getData() {
        return data;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "Task: " + batchId + " : " + externalId;
    }
}
