package io.taskmonk.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class BatchStatus {
    Integer newCount;
    Integer inProgress;
    Integer completed;
    Integer total;
    Date eta;
    String etaType;
    BatchState state;
    public BatchStatus() {

    }
    public BatchStatus(Integer newCount, Integer inProgress, Integer completed, Integer total) {
        this.completed = completed;
        this.newCount = newCount;
        this.inProgress = inProgress;
        this.total = total;
    }

    @JsonProperty("new_count")
    public Integer getNewCount() {
        return newCount;
    }

    @JsonProperty("new_count")
    public void setNewCount(Integer newCount) {
        this.newCount = newCount;
    }

    @JsonProperty("in_progress")
    public Integer getInProgress() {
        return inProgress;
    }

    @JsonProperty("in_progress")
    public void setInProgress(Integer inProgress) {
        this.inProgress = inProgress;
    }

    public Integer getCompleted() {
        return completed;
    }

    public void setCompleted(Integer completed) {
        this.completed = completed;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Date getEta() {
        return eta;
    }

    public void setEta(Date eta) {
        this.eta = eta;
    }

    @JsonProperty("eta_type")
    public String getEtaType() {
        return etaType;
    }

    @JsonProperty("eta_type")
    public void setEtaType(String etaType) {
        this.etaType = etaType;
    }

    public BatchState getState() {
        return state;
    }

    public void setState(BatchState state) {
        this.state = state;
    }

    @Override
    public String toString() {
        return "completed = " + completed + "; total = " + total + "; state = " + state + "; eta = " + eta;
    }
}
