/*
 * Decompiled with CFR 0.152.
 */
package io.taskmonk.streaming;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.taskmonk.streaming.MessageStreamWriter;
import io.taskmonk.streaming.NewTasks;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class StreamWriter {
    String queueName;
    String accessKey;
    MessageStreamWriter messageStreamWriter;

    public StreamWriter(String queueName, String accessKey) {
        this.queueName = queueName;
        this.accessKey = accessKey;
        this.messageStreamWriter = new MessageStreamWriter(queueName, accessKey);
    }

    public String send(String projectId, String batchId, List<Map<String, String>> tasks) throws Exception {
        NewTasks newTasks = new NewTasks();
        newTasks.project_id = projectId;
        newTasks.batch_id = batchId;
        newTasks.tasks = tasks;
        String messageId = UUID.randomUUID().toString();
        String label = String.format("%s:%s", projectId, batchId);
        String content = new ObjectMapper().writeValueAsString((Object)newTasks);
        this.messageStreamWriter.send(messageId, label, content);
        return messageId;
    }
}

