/*
 * Decompiled with CFR 0.152.
 */
package io.taskmonk.streaming;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import io.taskmonk.entities.BatchStatus;
import io.taskmonk.entities.Task;
import io.taskmonk.streaming.MessageAction;
import io.taskmonk.streaming.MessageListener;
import io.taskmonk.streaming.MessageStreamListener;
import io.taskmonk.streaming.azure.MessageHandler;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamListener {
    private static final Logger logger = LoggerFactory.getLogger(StreamListener.class);
    String queueName;
    String accessKey;
    MessageStreamListener messageStreamListener;

    public StreamListener(String queueName, String accessKey) {
        this.queueName = queueName;
        this.accessKey = accessKey;
        this.messageStreamListener = new MessageStreamListener(queueName, accessKey);
    }

    public Boolean addListener(final MessageListener listener) throws ServiceBusException, InterruptedException {
        return this.messageStreamListener.addMessageHandler(new MessageHandler(){

            @Override
            public MessageAction handle(String message) throws IOException {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode rootNode = (JsonNode)mapper.readValue(message.getBytes(), JsonNode.class);
                String messageType = rootNode.get("message_type").asText();
                if (messageType.equalsIgnoreCase("task_update")) {
                    logger.trace("Handling task_update message");
                    JsonNode taskNode = rootNode.get("task");
                    Task task = (Task)mapper.treeToValue((TreeNode)taskNode, Task.class);
                    return listener.onTaskUpdate(task);
                }
                if (messageType.equalsIgnoreCase("batch_status")) {
                    logger.trace("Handling batch_status message");
                    JsonNode node = rootNode.get("batch");
                    BatchStatus batchStatus = (BatchStatus)mapper.treeToValue((TreeNode)node, BatchStatus.class);
                    return listener.onBatchStatus(batchStatus);
                }
                logger.error("Unrecognised message {}", (Object)messageType);
                return listener.onGenericMessage(message);
            }
        });
    }
}

