/*
 * Decompiled with CFR 0.152.
 */
package io.taskmonk.entities;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class TaskQueryParams {
    List<String> fields = new ArrayList<String>();
    Date taskCompleteStart;
    Date taskCompleteEnd;
    String taskState;
    Integer pageSize;
    Integer pageNumber;
    String format = "dd-MM-yyyy";
    SimpleDateFormat df = new SimpleDateFormat(this.format);

    public List<String> getFields() {
        return this.fields;
    }

    public TaskQueryParams setFields(List<String> fields_names) {
        this.fields = fields_names;
        return this;
    }

    public Date getTaskCompleteStart() {
        return this.taskCompleteStart;
    }

    public TaskQueryParams setTaskCompleteStart(Date taskCompleteStart) {
        this.taskCompleteStart = taskCompleteStart;
        return this;
    }

    public Date getTaskCompleteEnd() {
        return this.taskCompleteEnd;
    }

    public TaskQueryParams setTaskCompleteEnd(Date taskCompleteEnd) {
        this.taskCompleteEnd = taskCompleteEnd;
        return this;
    }

    public String getTaskState() {
        return this.taskState;
    }

    public TaskQueryParams setTaskState(String taskState) {
        this.taskState = taskState;
        return this;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public TaskQueryParams setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public TaskQueryParams setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    public List<NameValuePair> getParameters() {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>();
        if (this.fields != null && this.fields.size() > 0) {
            for (String field : this.fields) {
                result.add((NameValuePair)new BasicNameValuePair("field_names[]", field));
            }
        }
        if (this.pageSize != null) {
            result.add((NameValuePair)new BasicNameValuePair("page_size", this.pageSize.toString()));
        }
        if (this.pageNumber != null) {
            result.add((NameValuePair)new BasicNameValuePair("page_no", this.pageNumber.toString()));
        }
        if (this.taskCompleteStart != null) {
            result.add((NameValuePair)new BasicNameValuePair("task_complete_start", this.df.format(this.taskCompleteStart)));
        }
        if (this.taskCompleteEnd != null) {
            result.add((NameValuePair)new BasicNameValuePair("task_complete_end", this.df.format(this.taskCompleteEnd)));
        }
        if (this.taskState != null) {
            result.add((NameValuePair)new BasicNameValuePair("task_state", this.taskState));
        }
        return result;
    }
}

