/*
 * Decompiled with CFR 0.152.
 */
package io.taskmonk.streaming.azure;

import com.microsoft.azure.servicebus.ExceptionPhase;
import com.microsoft.azure.servicebus.IMessage;
import com.microsoft.azure.servicebus.IMessageHandler;
import com.microsoft.azure.servicebus.QueueClient;
import io.taskmonk.streaming.MessageAction;
import io.taskmonk.streaming.azure.MessageHandler;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureQueueMessageHandler
implements IMessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(AzureQueueMessageHandler.class);
    MessageHandler messageHandler;
    QueueClient queueClient;

    AzureQueueMessageHandler(QueueClient queueClient, MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        this.queueClient = queueClient;
    }

    public CompletableFuture<Void> onMessageAsync(IMessage message) {
        logger.trace("Processing {}", (Object)message.getLockToken());
        block3 : switch (message.getMessageBody().getBodyType()) {
            case BINARY: {
                MessageAction result = null;
                try {
                    result = this.messageHandler.handle(new String((byte[])message.getMessageBody().getBinaryData().get(0), StandardCharsets.UTF_8));
                    switch (result) {
                        case ABANDON: {
                            logger.trace("Abandoning {}", (Object)message.getLockToken());
                            this.queueClient.abandon(message.getLockToken());
                            break block3;
                        }
                        case COMPLETE: {
                            logger.trace("Completing {}", (Object)message.getLockToken());
                            this.queueClient.complete(message.getLockToken());
                            break block3;
                        }
                    }
                    logger.trace("Invalid action {}", (Object)message.getLockToken());
                    this.queueClient.complete(message.getLockToken());
                }
                catch (Exception ex) {
                    logger.error(message.getLockToken().toString(), (Throwable)ex);
                    try {
                        this.queueClient.deadLetter(message.getLockToken());
                    }
                    catch (Exception e) {
                        logger.error(message.getLockToken().toString(), (Throwable)e);
                    }
                }
                break;
            }
            default: {
                logger.error("Unhandled message type : " + message.getMessageBody().getBodyType());
                try {
                    this.queueClient.deadLetter(message.getLockToken());
                    break;
                }
                catch (Exception e) {
                    logger.error(message.getLockToken().toString(), (Throwable)e);
                }
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    public void notifyException(Throwable exception, ExceptionPhase phase) {
        logger.error(phase.toString(), exception);
    }
}

