package io.taskmonk.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.HashMap;
import java.util.Map;

/**
 * Holds the data for a single Task. This is used for both uploading data to Taskmonk and for
 * receiving updates from Taskmonk
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Task {
    /**
     * The batch id for the task. This is set only when retrieving tasks from multiple projects. This
     * need not be set when uploading tasks to Taskmonk
     */
    public String batchId;

    /**
     * The external id is used for correlation when sending and receiving tasks. The same externalId will be set
     * when Taskmonk sends an update for the task back. This is optional.
     */
    public String externalId;

    /**
     * The data for the task. The key would be the field name and the value would be the field value. When Taskmonk
     * sends back the updated task, this would contain the output field values also.
     */
    public Map<String, String> data;

    public Task() {

    }
    public Task(String batchId, String externalId,
                Map<String, String> data) {
        this.batchId = batchId;
        this.externalId = externalId;
        this.data = data;
    }

    public Task(String externalId,
                Map<String, String> data) {
        this.externalId = externalId;
        this.data = data;
    }

    @JsonProperty("batch_id")
    public String getBatchId() {
        return batchId;
    }

    @JsonProperty("batch_id")
    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }


    @JsonProperty("external_id")
    public String getExternalId() {
        return externalId;
    }

    @JsonProperty("external_id")
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Map<String, String> getData() {
        return data;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "Task: " + batchId + " : " + externalId;
    }
}
