/*
 * Decompiled with CFR 0.152.
 */
package io.taskmonk.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.taskmonk.auth.OAuthClientCredentials;
import io.taskmonk.auth.TokenResponse;
import io.taskmonk.entities.BatchOutput;
import io.taskmonk.entities.BatchStatus;
import io.taskmonk.entities.Id;
import io.taskmonk.entities.JobProgressResponse;
import io.taskmonk.entities.NewBatchData;
import io.taskmonk.entities.TaskImportResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskMonkClient {
    private static final Logger logger = LoggerFactory.getLogger(TaskMonkClient.class);
    HttpHost httpHost;
    TokenResponse tokenResponse;
    String projectId;
    OAuthClientCredentials credentials;

    private TokenResponse refreshToken() throws Exception {
        URIBuilder builder = new URIBuilder(this.httpHost.toString() + "/api/oauth2/token").addParameter("grant_type", "client_credentials").addParameter("client_id", this.credentials.getClientId()).addParameter("client_secret", this.credentials.getClientSecret());
        HttpPost post = new HttpPost(builder.build());
        CloseableHttpAsyncClient httpclient = HttpAsyncClients.custom().build();
        httpclient.start();
        Future future = httpclient.execute((HttpUriRequest)post, null);
        HttpResponse response = (HttpResponse)future.get();
        String content = EntityUtils.toString((HttpEntity)response.getEntity());
        ObjectMapper mapper = new ObjectMapper();
        TokenResponse tokenResponse = (TokenResponse)mapper.readValue(content, TokenResponse.class);
        httpclient.close();
        return tokenResponse;
    }

    private TokenResponse getTokenResponse() throws Exception {
        if (this.tokenResponse == null || this.tokenResponse.isExpired().booleanValue()) {
            this.tokenResponse = this.refreshToken();
        }
        return this.tokenResponse;
    }

    private void downloadFile(String url, String localPath) throws Exception {
        ReadableByteChannel rbc = Channels.newChannel(new URL(url).openStream());
        FileOutputStream fos = new FileOutputStream(localPath);
        fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
    }

    private HttpPost getHttpPost(String path, List<NameValuePair> parameters, ContentType contentType) throws Exception {
        URIBuilder builder = new URIBuilder(this.httpHost.toString() + path);
        builder.addParameters(parameters);
        HttpPost post = new HttpPost(builder.build());
        post.addHeader("Authorization", "Bearer " + this.getTokenResponse().getAccess_token());
        post.addHeader("Content-type", contentType.toString());
        return post;
    }

    private HttpGet getHttpGet(String path) throws Exception {
        return this.getHttpGet(path, new ArrayList<NameValuePair>());
    }

    private HttpGet getHttpGet(String path, List<NameValuePair> parameters) throws Exception {
        URIBuilder builder = new URIBuilder(this.httpHost.toString() + path).addParameters(parameters);
        HttpGet get = new HttpGet(builder.build());
        get.addHeader("Authorization", "Bearer " + this.getTokenResponse().getAccess_token());
        return get;
    }

    public String createBatch(String batchName) throws Exception {
        URIBuilder builder = new URIBuilder(this.httpHost.toString() + "/api/project/" + this.projectId + "/batch");
        HttpPost post = new HttpPost(builder.build());
        post.addHeader("Authorization", "Bearer " + this.getTokenResponse().getAccess_token());
        post.addHeader("Content-type", "application/json");
        NewBatchData newBatchData = new NewBatchData(batchName);
        ObjectMapper mapper = new ObjectMapper();
        String body = mapper.writeValueAsString((Object)newBatchData);
        logger.debug("batch create content = {}", (Object)body);
        System.out.println("body = " + body);
        StringEntity stringEntity = new StringEntity(body);
        post.setEntity((HttpEntity)stringEntity);
        CloseableHttpAsyncClient httpclient = HttpAsyncClients.custom().build();
        httpclient.start();
        Future future = httpclient.execute((HttpUriRequest)post, null);
        HttpResponse response = (HttpResponse)future.get();
        httpclient.close();
        String content = EntityUtils.toString((HttpEntity)response.getEntity());
        Id batchId = (Id)mapper.readValue(content, Id.class);
        logger.debug("batch id = " + batchId);
        return batchId.id;
    }

    public TaskImportResponse uploadTasks(String batchName, File file) throws Exception {
        logger.debug("Uploading tasks to batch {}", (Object)batchName);
        String batchId = this.createBatch(batchName);
        String path = file.getAbsolutePath();
        String fileType = FilenameUtils.getExtension((String)path);
        logger.debug("fileType = {}", (Object)fileType);
        byte[] bytes = Files.readAllBytes(file.toPath());
        ByteArrayOutputStream arrOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream zipOutputStream = new GZIPOutputStream(arrOutputStream);
        zipOutputStream.write(bytes);
        zipOutputStream.close();
        arrOutputStream.close();
        byte[] output = arrOutputStream.toByteArray();
        String encoded = Base64.getEncoder().encodeToString(output);
        logger.debug("Uploading {} bytes", (Object)encoded.length());
        URIBuilder builder = new URIBuilder(this.httpHost.toString() + "/api/project/" + this.projectId + "/batch/" + batchId + "/tasks/import");
        builder.addParameter("fileType", fileType);
        HttpPost post = new HttpPost(builder.build());
        post.addHeader("Authorization", "Bearer " + this.getTokenResponse().getAccess_token());
        StringEntity stringEntity = new StringEntity(encoded);
        post.setEntity((HttpEntity)stringEntity);
        CloseableHttpAsyncClient httpclient = HttpAsyncClients.custom().build();
        httpclient.start();
        Future future = httpclient.execute((HttpUriRequest)post, null);
        HttpResponse response = (HttpResponse)future.get();
        String content = EntityUtils.toString((HttpEntity)response.getEntity());
        httpclient.close();
        ObjectMapper mapper = new ObjectMapper();
        TaskImportResponse importResponse = (TaskImportResponse)mapper.readValue(content, TaskImportResponse.class);
        System.out.println("importResponse = " + importResponse);
        return importResponse;
    }

    private void waitForCompletion(String jobId) throws Exception {
        JobProgressResponse jobProgressResponse = this.getJobProgress(jobId);
        while (!jobProgressResponse.isCompleted().booleanValue()) {
            Thread.sleep(2000L);
            jobProgressResponse = this.getJobProgress(jobId);
        }
    }

    public void getBatchOutput(String batchId, String outputFormat, String outputPath) throws Exception {
        String url = "/api/project/" + this.projectId + "/batch/" + batchId + "/output";
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("output_format", outputFormat));
        HashMap fieldNames = new HashMap();
        fieldNames.put("fieldNames", new ArrayList());
        ObjectMapper mapper = new ObjectMapper();
        String content = mapper.writeValueAsString(fieldNames);
        HttpPost post = this.getHttpPost(url, parameters, ContentType.APPLICATION_JSON);
        post.setEntity((HttpEntity)new StringEntity(content));
        BatchOutput batchOutput = this.getResponse(post, BatchOutput.class);
        logger.debug("batchOutput = {}", (Object)batchOutput);
        this.waitForCompletion(batchOutput.getJobId());
        this.downloadFile(batchOutput.getFileUrl(), outputPath);
    }

    private <T> T getResponse(HttpPost post, Class<T> clazz) throws ExecutionException, InterruptedException, IOException {
        logger.debug("Running post {}", (Object)post);
        CloseableHttpAsyncClient httpclient = HttpAsyncClients.custom().build();
        httpclient.start();
        Future future = httpclient.execute((HttpUriRequest)post, null);
        HttpResponse response = (HttpResponse)future.get();
        String content = EntityUtils.toString((HttpEntity)response.getEntity());
        logger.debug("Got response {}", (Object)content);
        ObjectMapper mapper = new ObjectMapper();
        Object result = mapper.readValue(content, clazz);
        httpclient.close();
        return (T)result;
    }

    private <T> T getResponse(HttpGet get, Class<T> clazz) throws ExecutionException, InterruptedException, IOException {
        logger.debug("Running get {}", (Object)get);
        CloseableHttpAsyncClient httpclient = HttpAsyncClients.custom().build();
        httpclient.start();
        Future future = httpclient.execute((HttpUriRequest)get, null);
        HttpResponse response = (HttpResponse)future.get();
        String content = EntityUtils.toString((HttpEntity)response.getEntity());
        ObjectMapper mapper = new ObjectMapper();
        Object result = mapper.readValue(content, clazz);
        logger.debug("Got response {}", result);
        httpclient.close();
        return (T)result;
    }

    public JobProgressResponse getJobProgress(String jobId) throws Exception {
        String url = "/api/project/" + this.projectId + "/job/" + jobId + "/status";
        HttpGet httpGet = this.getHttpGet(url);
        JobProgressResponse getResponse = this.getResponse(httpGet, JobProgressResponse.class);
        return getResponse;
    }

    public JobProgressResponse getJobProgressBatch(String batchId) throws Exception {
        String url = "/api/project/" + this.projectId + "/job/" + batchId + "/status";
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("input_type", "batch"));
        HttpGet httpGet = this.getHttpGet(url, parameters);
        JobProgressResponse getResponse = this.getResponse(httpGet, JobProgressResponse.class);
        return getResponse;
    }

    public BatchStatus getBatchStatus(String batchId) throws Exception {
        String url = "/api/project/v2/" + this.projectId + "/batch/" + batchId + "/status";
        HttpGet httpGet = this.getHttpGet(url);
        BatchStatus getResponse = this.getResponse(httpGet, BatchStatus.class);
        return getResponse;
    }

    public Boolean isProcessComplete(String batchId) throws Exception {
        BatchStatus batchStatus = this.getBatchStatus(batchId);
        return batchStatus.getCompleted().equals(batchStatus.getTotal());
    }

    public Boolean isUploadComplete(String batchId) throws Exception {
        JobProgressResponse jobResponse = this.getJobProgressBatch(batchId);
        return jobResponse.isCompleted();
    }

    public TaskMonkClient(String projectId, String server, OAuthClientCredentials credentials) {
        this.projectId = projectId;
        this.credentials = credentials;
        this.httpHost = server.startsWith("http") ? new HttpHost(server) : new HttpHost(server, 80, "http");
    }
}

