/*
 * Decompiled with CFR 0.152.
 */
package swim.warp;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.Input;
import swim.codec.InputBuffer;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.recon.Recon;
import swim.structure.Item;
import swim.structure.Value;
import swim.warp.Envelope;

final class EnvelopeDecoder
extends Decoder<Envelope> {
    final Decoder<Value> output;

    EnvelopeDecoder(Decoder<Value> output) {
        this.output = output;
    }

    EnvelopeDecoder() {
        this(null);
    }

    public Decoder<Envelope> feed(InputBuffer input) {
        return EnvelopeDecoder.decode(input, this.output);
    }

    static Decoder<Envelope> decode(InputBuffer input, Decoder<Value> output) {
        if ((output = output == null ? Utf8.parseDecoded((Parser)Recon.structureParser().blockParser(), (Input)input) : output.feed(input)).isDone()) {
            try {
                Value value = (Value)output.bind();
                Envelope envelope = Envelope.fromValue(value);
                if (envelope != null) {
                    return EnvelopeDecoder.done((Object)envelope);
                }
                return EnvelopeDecoder.error((Throwable)new DecoderException(Recon.toString((Item)value)));
            }
            catch (RuntimeException cause) {
                return EnvelopeDecoder.error((Throwable)cause);
            }
        }
        if (output.isError()) {
            return EnvelopeDecoder.error((Throwable)output.trap());
        }
        if (input.isError()) {
            return EnvelopeDecoder.error((Throwable)input.trap());
        }
        return new EnvelopeDecoder((Decoder<Value>)output);
    }
}

