/*
 * Decompiled with CFR 0.152.
 */
package swim.warp;

import swim.structure.Attr;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.LaneAddressed;
import swim.warp.LinkAddressed;

abstract class LinkAddressedForm<E extends LinkAddressed>
extends Form<E> {
    LinkAddressedForm() {
    }

    abstract E from(Uri var1, Uri var2, float var3, float var4, Value var5);

    public E unit() {
        return null;
    }

    public Item mold(E envelope) {
        if (envelope != null) {
            float rate;
            Record headers = Record.create((int)4).slot("node", ((LinkAddressed)envelope).nodeUri.toString()).slot("lane", ((LinkAddressed)envelope).laneUri.toString());
            float prio = ((LinkAddressed)envelope).prio;
            if (prio != 0.0f && !Float.isNaN(prio)) {
                headers.slot("prio", prio);
            }
            if ((rate = ((LinkAddressed)envelope).rate) != 0.0f && !Float.isNaN(rate)) {
                headers.slot("rate", rate);
            }
            return Attr.of((String)this.tag(), (Value)headers).concat((Item)((LaneAddressed)envelope).body());
        }
        return Item.extant();
    }

    public E cast(Item item) {
        Value value = item.toValue();
        Record headers = value.headers(this.tag());
        Uri nodeUri = null;
        Uri laneUri = null;
        float prio = 0.0f;
        float rate = 0.0f;
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            Item header = headers.get(i);
            String key = header.key().stringValue(null);
            if (key != null) {
                if ("node".equals(key)) {
                    nodeUri = Uri.parse((String)header.toValue().stringValue(""));
                    continue;
                }
                if ("lane".equals(key)) {
                    laneUri = Uri.parse((String)header.toValue().stringValue(""));
                    continue;
                }
                if ("prio".equals(key)) {
                    prio = header.toValue().floatValue();
                    continue;
                }
                if (!"rate".equals(key)) continue;
                rate = header.toValue().floatValue();
                continue;
            }
            if (!(header instanceof Value)) continue;
            if (i == 0) {
                nodeUri = Uri.parse((String)header.stringValue(""));
                continue;
            }
            if (i != 1) continue;
            laneUri = Uri.parse((String)header.stringValue(""));
        }
        if (nodeUri != null && laneUri != null) {
            Value body = value.body();
            return this.from(nodeUri, laneUri, prio, rate, body);
        }
        return null;
    }
}

