/*
 * Decompiled with CFR 0.152.
 */
package swim.warp;

import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.EventMessageForm;
import swim.warp.LaneAddressed;

public final class EventMessage
extends LaneAddressed {
    @Kind
    public static final Form<EventMessage> FORM = new EventMessageForm();

    public EventMessage(Uri nodeUri, Uri laneUri, Value body) {
        super(nodeUri, laneUri, body);
    }

    public EventMessage(Uri nodeUri, Uri laneUri) {
        this(nodeUri, laneUri, Value.absent());
    }

    public EventMessage(String nodeUri, String laneUri, Value body) {
        this(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), body);
    }

    public EventMessage(String nodeUri, String laneUri) {
        this(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), Value.absent());
    }

    @Override
    public String tag() {
        return "event";
    }

    public Form<EventMessage> form() {
        return FORM;
    }

    @Override
    public EventMessage nodeUri(Uri nodeUri) {
        return new EventMessage(nodeUri, this.laneUri, this.body);
    }

    @Override
    public EventMessage laneUri(Uri laneUri) {
        return new EventMessage(this.nodeUri, laneUri, this.body);
    }

    @Override
    public EventMessage body(Value body) {
        return new EventMessage(this.nodeUri, this.laneUri, body);
    }
}

