/*
 * Decompiled with CFR 0.152.
 */
package swim.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import swim.util.Cursor;
import swim.util.IterableMap;
import swim.util.OrderedMapCursor;
import swim.util.OrderedMapView;

public interface OrderedMap<K, V>
extends IterableMap<K, V>,
SortedMap<K, V> {
    @Override
    public boolean isEmpty();

    @Override
    public int size();

    @Override
    public boolean containsKey(Object var1);

    @Override
    public boolean containsValue(Object var1);

    public int indexOf(Object var1);

    @Override
    public V get(Object var1);

    public Map.Entry<K, V> getEntry(Object var1);

    public Map.Entry<K, V> getIndex(int var1);

    @Override
    public Map.Entry<K, V> firstEntry();

    @Override
    public K firstKey();

    public V firstValue();

    @Override
    public Map.Entry<K, V> lastEntry();

    @Override
    public K lastKey();

    public V lastValue();

    public Map.Entry<K, V> nextEntry(K var1);

    public K nextKey(K var1);

    public V nextValue(K var1);

    public Map.Entry<K, V> previousEntry(K var1);

    public K previousKey(K var1);

    public V previousValue(K var1);

    @Override
    public V put(K var1, V var2);

    @Override
    default public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object var1);

    @Override
    public void clear();

    @Override
    default public OrderedMap<K, V> headMap(K toKey) {
        return new OrderedMapView(this, null, toKey);
    }

    @Override
    default public OrderedMap<K, V> tailMap(K fromKey) {
        return new OrderedMapView(this, fromKey, null);
    }

    @Override
    default public OrderedMap<K, V> subMap(K fromKey, K toKey) {
        return new OrderedMapView(this, fromKey, toKey);
    }

    @Override
    default public Set<Map.Entry<K, V>> entrySet() {
        return IterableMap.super.entrySet();
    }

    @Override
    default public Set<K> keySet() {
        return IterableMap.super.keySet();
    }

    @Override
    default public Collection<V> values() {
        return IterableMap.super.values();
    }

    @Override
    public OrderedMapCursor<K, V> iterator();

    @Override
    default public Cursor<K> keyIterator() {
        return IterableMap.super.keyIterator();
    }

    @Override
    default public Cursor<V> valueIterator() {
        return IterableMap.super.valueIterator();
    }

    @Override
    public Comparator<? super K> comparator();
}

